/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.Variables;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.GlobalActorHandler;
import adams.flow.core.InputConsumer;
import adams.flow.sink.AbstractDisplay;
import adams.flow.sink.AbstractSink;
import adams.flow.sink.ComponentSupplier;
import adams.flow.sink.SequencePlotter;
import adams.flow.sink.TextSupplier;
import adams.flow.standalone.GlobalActors;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.print.JComponentWriter;
import adams.gui.print.PNGWriter;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractMultiView
extends adams.flow.core.AbstractDisplay
implements GlobalActorHandler,
MenuBarProvider,
SendToActionSupporter {
    private static final long serialVersionUID = -4454052058077687116L;
    protected List<AbstractActor> m_Actors;
    protected List<ViewWrapper> m_Wrappers;
    protected JComponentWriter m_Writer;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemFileClose;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actor", "actors", new AbstractActor[0]);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Actors = new ArrayList<AbstractActor>();
        this.m_Wrappers = null;
    }

    @Override
    public void setHeadless(boolean value) {
        super.setHeadless(value);
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setHeadless(value);
        }
    }

    public void setActors(AbstractActor[] value) {
        int i;
        ActorUtils.uniqueNames(value);
        for (i = 0; i < value.length; ++i) {
            String msg = this.check(value[i]);
            if (msg == null) continue;
            this.getLogger().severe(msg);
            return;
        }
        this.m_Actors.clear();
        for (i = 0; i < value.length; ++i) {
            this.m_Actors.add(value[i]);
        }
        this.updateParent();
        this.reset();
    }

    public AbstractActor[] getActors() {
        return this.m_Actors.toArray(new AbstractActor[this.m_Actors.size()]);
    }

    public abstract String actorsTipText();

    protected String check(AbstractActor actor) {
        if (!(actor instanceof adams.flow.core.AbstractDisplay)) {
            return "Actor '" + actor.getName() + "' not derived from " + AbstractDisplay.class.getName() + "!";
        }
        if (!ActorUtils.isSink(actor)) {
            return "Actor '" + actor.getName() + "' is not a sink!";
        }
        if (this.getScopeHandler() != null) {
            return this.getScopeHandler().addGlobalName(actor.getName());
        }
        return null;
    }

    protected void updateParent() {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setParent(null);
            this.get(i).setParent(this);
        }
    }

    @Override
    public void add(AbstractActor actor) {
        String msg = this.check(actor);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        this.m_Actors.add(actor);
    }

    @Override
    public void add(int index, AbstractActor actor) {
        String msg = this.check(actor);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        this.m_Actors.add(index, actor);
    }

    @Override
    public AbstractActor remove(int index) {
        return this.m_Actors.remove(index);
    }

    @Override
    public void removeAll() {
        this.m_Actors.clear();
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(true, false, ActorExecution.PARALLEL, false, new Class[]{AbstractDisplay.class});
    }

    protected String checkGlobalActors() {
        String result = null;
        int index = this.index();
        if (index == -1) {
            return result;
        }
        ActorHandler parent = (ActorHandler)((Object)this.getParent());
        for (int i = 0; i < index; ++i) {
            if (!(parent.get(i) instanceof GlobalActors)) continue;
            result = "The GlobalActors standalone cannot precede a " + this.getClass().getSimpleName() + ", " + "but found one at index #" + (i + 1) + "!";
            break;
        }
        return result;
    }

    @Override
    public String check() {
        String result = null;
        for (int i = 0; i < this.m_Actors.size() && (result = this.check(this.m_Actors.get(i))) == null; ++i) {
        }
        return result;
    }

    @Override
    public int size() {
        return this.m_Actors.size();
    }

    @Override
    public AbstractActor get(int index) {
        if (this.m_Wrappers != null) {
            return this.m_Wrappers.get(index);
        }
        return this.m_Actors.get(index);
    }

    @Override
    public void set(int index, AbstractActor actor) {
        String msg = this.check(actor);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        this.m_Actors.set(index, actor);
    }

    @Override
    public int indexOf(String actor) {
        int result = -1;
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            if (!this.m_Actors.get(i).getName().equals(actor)) continue;
            result = i;
            break;
        }
        return result;
    }

    @Override
    public AbstractActor firstActive() {
        AbstractActor result = null;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).getSkip()) continue;
            result = this.get(i);
            break;
        }
        return result;
    }

    @Override
    public AbstractActor lastActive() {
        AbstractActor result = null;
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.get(i).getSkip()) continue;
            result = this.get(i);
            break;
        }
        return result;
    }

    @Override
    public void clearPanel() {
        if (this.m_Wrappers != null) {
            for (ViewWrapper wrapper : this.m_Wrappers) {
                wrapper.clearPanel();
            }
        }
    }

    @Override
    protected abstract BasePanel newPanel();

    @Override
    protected Runnable newDisplayRunnable() {
        Runnable result = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (AbstractMultiView.this.m_CreateFrame && !AbstractMultiView.this.m_Frame.isVisible()) {
                    AbstractMultiView.this.m_Frame.setVisible(true);
                }
                AbstractActor abstractActor = AbstractMultiView.this.m_Self;
                synchronized (abstractActor) {
                    AbstractMultiView.this.m_Self.notifyAll();
                }
                AbstractMultiView.this.m_Updating = false;
            }
        };
        this.m_InputToken = null;
        return result;
    }

    @Override
    public synchronized void setVariables(Variables value) {
        super.setVariables(value);
        if (this.m_Wrappers != null) {
            for (ViewWrapper wrapper : this.m_Wrappers) {
                wrapper.setVariables(value);
            }
        }
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            result = this.checkGlobalActors();
        }
        if (result == null) {
            result = this.check();
        }
        if (result == null) {
            this.m_Wrappers = new ArrayList<ViewWrapper>();
            for (AbstractActor actor : this.m_Actors) {
                ((adams.flow.core.AbstractDisplay)actor).setCreateFrame(false);
                ViewWrapper wrapper = new ViewWrapper();
                wrapper.setParent(this);
                wrapper.setName(actor.getName());
                wrapper.setWrapped(actor);
                result = wrapper.setUp();
                if (result != null) {
                    result = "Failed to wrap actor '" + actor.getName() + "': " + result;
                    break;
                }
                this.m_Wrappers.add(wrapper);
            }
        }
        return result;
    }

    @Override
    protected String doExecute() {
        for (ViewWrapper wrapper : this.m_Wrappers) {
            wrapper.setVariables(this.getVariables());
        }
        return super.doExecute();
    }

    public abstract void addPanel(AbstractActor var1, BasePanel var2);

    @Override
    public void stopExecution() {
        if (this.m_Wrappers != null) {
            for (ViewWrapper wrapper : this.m_Wrappers) {
                wrapper.stopExecution();
            }
        }
        super.stopExecution();
    }

    @Override
    public void wrapUp() {
        if (this.m_Wrappers != null) {
            for (ViewWrapper wrapper : this.m_Wrappers) {
                wrapper.wrapUp();
            }
        }
        super.wrapUp();
    }

    @Override
    public void cleanUp() {
        if (this.m_Wrappers != null) {
            for (ViewWrapper wrapper : this.m_Wrappers) {
                wrapper.cleanUp();
            }
            this.m_Wrappers.clear();
            this.m_Wrappers = null;
        }
        super.cleanUp();
    }

    protected JMenuBar createMenuBar() {
        JMenuBar result = new JMenuBar();
        JMenu menu = new JMenu("File");
        result.add(menu);
        menu.setMnemonic('F');
        menu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractMultiView.this.updateMenu();
            }
        });
        if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, menu)) {
            menu.addSeparator();
        }
        JMenuItem menuitem = new JMenuItem("Close");
        menu.add(menuitem);
        menuitem.setMnemonic('C');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Q"));
        menuitem.setIcon(GUIHelper.getIcon("exit.png"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractMultiView.this.close();
            }
        });
        this.m_MenuItemFileClose = menuitem;
        return result;
    }

    @Override
    public JMenuBar getMenuBar() {
        if (this.m_MenuBar == null) {
            this.m_MenuBar = this.createMenuBar();
            this.updateMenu();
        }
        return this.m_MenuBar;
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
    }

    protected void close() {
        this.m_Panel.closeParent();
    }

    @Override
    public Class[] getSendToClasses() {
        boolean add;
        ArrayList<Class> result = new ArrayList<Class>();
        if (this instanceof SpreadSheetSupporter) {
            boolean bl = add = !this.isExecuted() || this.isExecuted() && ((SpreadSheetSupporter)((Object)this)).toSpreadSheet() != null;
            if (add) {
                result.add(SpreadSheet.class);
            }
        }
        if (this instanceof TextSupplier) {
            boolean bl = add = !this.isExecuted() || this.isExecuted() && ((TextSupplier)((Object)this)).supplyText() != null;
            if (add) {
                result.add(String.class);
            }
        }
        if (this instanceof ComponentSupplier) {
            boolean bl = add = !this.isExecuted() || this.isExecuted() && ((ComponentSupplier)((Object)this)).supplyComponent() != null;
            if (add) {
                result.add(PlaceholderFile.class);
                result.add(JComponent.class);
            }
        }
        return result.toArray(new Class[result.size()]);
    }

    @Override
    public boolean hasSendToItem(Class[] cls) {
        if (this instanceof TextSupplier && ((TextSupplier)((Object)this)).supplyText() != null && SendToActionUtils.isAvailable(new Class[]{String.class}, cls)) {
            return true;
        }
        if (this instanceof ComponentSupplier && ((ComponentSupplier)((Object)this)).supplyComponent() != null && SendToActionUtils.isAvailable(new Class[]{PlaceholderFile.class, JComponent.class}, cls)) {
            return true;
        }
        return this instanceof SpreadSheetSupporter && ((SpreadSheetSupporter)((Object)this)).toSpreadSheet() != null && SendToActionUtils.isAvailable(new Class[]{SpreadSheet.class}, cls);
    }

    @Override
    public Object getSendToItem(Class[] cls) {
        Object result = null;
        if (this instanceof TextSupplier && SendToActionUtils.isAvailable(new Class[]{String.class}, cls)) {
            result = ((TextSupplier)((Object)this)).supplyText();
        } else if (this instanceof SpreadSheetSupporter && SendToActionUtils.isAvailable(new Class[]{SpreadSheet.class}, cls)) {
            result = ((SpreadSheetSupporter)((Object)this)).toSpreadSheet();
        } else if (this instanceof ComponentSupplier) {
            JComponent comp = ((ComponentSupplier)((Object)this)).supplyComponent();
            if (SendToActionUtils.isAvailable(PlaceholderFile.class, cls)) {
                if (comp != null) {
                    result = SendToActionUtils.nextTmpFile("actor-" + this.getName(), "png");
                    PNGWriter writer = new PNGWriter();
                    writer.setFile((PlaceholderFile)result);
                    writer.setComponent(comp);
                    try {
                        writer.generateOutput();
                    }
                    catch (Exception e) {
                        this.handleException("Failed to write image to " + result + ":", e);
                        result = null;
                    }
                }
            } else if (SendToActionUtils.isAvailable(JComponent.class, cls)) {
                result = comp;
            }
        }
        return result;
    }

    public static class ViewWrapper
    extends AbstractSink {
        private static final long serialVersionUID = -1571827759359015717L;
        protected adams.flow.core.AbstractDisplay m_Wrapped;
        protected BasePanel m_Panel;

        @Override
        public String globalInfo() {
            return "Wrapper for sinks to be used in the multi-view sink.";
        }

        @Override
        public void defineOptions() {
            super.defineOptions();
            this.m_OptionManager.add("wrapped", "wrapped", new SequencePlotter());
        }

        public void setWrapped(AbstractActor value) {
            this.m_Wrapped = (adams.flow.core.AbstractDisplay)value;
            this.m_Wrapped.setParent(this);
            this.reset();
        }

        public AbstractActor getWrapped() {
            return this.m_Wrapped;
        }

        public String wrappedTipText() {
            return "The actor to wrap.";
        }

        @Override
        public String getQuickInfo() {
            return QuickInfoHelper.toString((OptionHandler)this, "wrapped", this.m_Wrapped);
        }

        @Override
        public Class[] accepts() {
            return ((InputConsumer)((Object)this.m_Wrapped)).accepts();
        }

        @Override
        public synchronized void setVariables(Variables value) {
            super.setVariables(value);
            this.m_Wrapped.setVariables(value);
        }

        @Override
        protected String doExecute() {
            String result = null;
            if (this.m_Panel == null && (result = this.m_Wrapped.execute()) == null) {
                this.m_Panel = this.m_Wrapped.getPanel();
                ((AbstractMultiView)this.getParent()).addPanel(this.m_Wrapped, this.m_Panel);
            }
            if (result == null) {
                this.m_Wrapped.input(this.m_InputToken);
                result = this.m_Wrapped.execute();
            }
            return result;
        }

        @Override
        public void wrapUp() {
            if (this.m_Wrapped != null) {
                this.m_Wrapped.wrapUp();
            }
            super.wrapUp();
        }

        @Override
        public void cleanUp() {
            if (this.m_Panel != null) {
                this.m_Wrapped.clearPanel();
                this.m_Wrapped.cleanUp();
                this.m_Panel = null;
            }
            super.cleanUp();
        }

        public void clearPanel() {
            if (this.m_Panel != null) {
                this.m_Wrapped.clearPanel();
            }
        }
    }
}

