/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.Placeholders;
import adams.core.QuickInfoHelper;
import adams.core.SystemInfo;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.standalone.AbstractStandalone;
import java.lang.reflect.Method;

public class Java
extends AbstractStandalone {
    private static final long serialVersionUID = -132045002653940359L;
    protected String m_Command;
    protected boolean m_CommandContainsPlaceholder;
    protected boolean m_CommandContainsVariable;

    @Override
    public String globalInfo() {
        return "Calls the main method of a Java class.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cmd", "command", SystemInfo.class.getName());
        this.m_OptionManager.add("placeholder", "commandContainsPlaceholder", false);
        this.m_OptionManager.add("variable", "commandContainsVariable", false);
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "command", this.m_Command);
    }

    public void setCommand(String value) {
        this.m_Command = value;
        this.reset();
    }

    public String getCommand() {
        return this.m_Command;
    }

    public String commandTipText() {
        return "The command to run, Java classname with options.";
    }

    public void setCommandContainsPlaceholder(boolean value) {
        this.m_CommandContainsPlaceholder = value;
        this.reset();
    }

    public boolean getCommandContainsPlaceholder() {
        return this.m_CommandContainsPlaceholder;
    }

    public String commandContainsPlaceholderTipText() {
        return "Set this to true to enable automatic placeholder expansion for the command string.";
    }

    public void setCommandContainsVariable(boolean value) {
        this.m_CommandContainsVariable = value;
        this.reset();
    }

    public boolean getCommandContainsVariable() {
        return this.m_CommandContainsVariable;
    }

    public String commandContainsVariableTipText() {
        return "Set this to true to enable automatic variable expansion for the command string.";
    }

    @Override
    protected String doExecute() {
        String result = null;
        String cmd = this.m_Command;
        if (this.m_CommandContainsVariable) {
            cmd = this.getVariables().expand(cmd);
        }
        if (this.m_CommandContainsPlaceholder) {
            cmd = Placeholders.getSingleton().expand(cmd).replace("\\", "/");
        }
        try {
            String[] cmdArray = OptionUtils.splitOptions(cmd);
            Class<?> cls = Class.forName(cmdArray[0]);
            cmdArray[0] = "";
            cmdArray = cmdArray.length == 1 ? new String[]{} : OptionUtils.splitOptions(OptionUtils.joinOptions(cmdArray));
            Method method = cls.getMethod("main", String[].class);
            if ((method.getModifiers() & 8) == 0 || (method.getModifiers() & 1) == 0) {
                throw new IllegalArgumentException("'main' method must be static and public!");
            }
            method.invoke(null, new Object[]{cmdArray});
        }
        catch (Exception e) {
            result = this.handleException("Failed to execute command: " + cmd, e);
        }
        return result;
    }
}

