/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Properties;
import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public class PropertiesFileReader
extends AbstractTransformer {
    private static final long serialVersionUID = -184602726110144511L;

    @Override
    public String globalInfo() {
        return "Reads a Java Properties file.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Properties.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        Object fileObj = this.m_InputToken.getPayload();
        File file = fileObj instanceof File ? (File)fileObj : new PlaceholderFile((String)fileObj);
        try {
            Properties props = new Properties();
            if (props.load(file.getAbsolutePath())) {
                this.m_OutputToken = new Token(props);
            } else {
                result = "Failed to read properties file: " + file;
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to read properties file: " + file, e);
        }
        return result;
    }
}

