/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class Sort
extends AbstractTransformer {
    private static final long serialVersionUID = -1405106607250617855L;
    protected boolean m_Reverse;
    protected boolean m_Unique;

    @Override
    public String globalInfo() {
        return "Actor for sorting arrays.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reverse", "reverse", false);
        this.m_OptionManager.add("unique", "unique", false);
    }

    @Override
    public String getQuickInfo() {
        ArrayList<String> options = new ArrayList<String>();
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "reverse", this.m_Reverse, "order reversed"));
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "unique", this.m_Unique, "unique"));
        String result = QuickInfoHelper.flatten(options);
        if (result.length() == 0) {
            return null;
        }
        return result;
    }

    public void setReverse(boolean value) {
        this.m_Reverse = value;
        this.reset();
    }

    public boolean getReverse() {
        return this.m_Reverse;
    }

    public String reverseTipText() {
        return "If set to true, then the sorting will be reversed.";
    }

    public void setUnique(boolean value) {
        this.m_Unique = value;
        this.reset();
    }

    public boolean getUnique() {
        return this.m_Unique;
    }

    public String uniqueTipText() {
        return "If set to true, then only unique entries will be output.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown[].class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (!this.m_InputToken.getPayload().getClass().isArray()) {
            this.getLogger().severe("Input is not an array - ignored!");
            this.m_OutputToken = new Token(this.m_InputToken.getPayload());
        } else {
            Object[] newObj;
            int i;
            Object[] obj = (Object[])Utils.deepCopy(this.m_InputToken.getPayload());
            if (this.isLoggingEnabled()) {
                this.getLogger().info("unsorted: " + Utils.arrayToString(obj));
            }
            if (this.m_Unique) {
                HashSet<Object> entries = new HashSet<Object>(Arrays.asList(obj));
                obj = (Object[])Array.newInstance(obj.getClass().getComponentType(), entries.size());
                i = 0;
                for (Object o : entries) {
                    Array.set(obj, i, o);
                    ++i;
                }
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("unique: " + Utils.arrayToString(obj));
                }
            }
            Arrays.sort(obj);
            if (!this.m_Reverse) {
                newObj = obj;
            } else {
                newObj = (Object[])Array.newInstance(obj.getClass().getComponentType(), obj.length);
                for (i = 0; i < obj.length; ++i) {
                    newObj[i] = obj[obj.length - i - 1];
                }
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("sorted: " + Utils.arrayToString(newObj));
            }
            this.m_OutputToken = new Token(newObj);
        }
        return result;
    }
}

