/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.FileEncodingSupporter;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TextFileReader
extends AbstractTransformer
implements FileEncodingSupporter {
    private static final long serialVersionUID = -184602726110144511L;
    protected String m_Encoding;
    protected OutputType m_OutputType;
    protected List m_Queue;

    @Override
    public String globalInfo() {
        return "Reads a text file and forwards the content. The content can either be forwarded as string array, line by line or as single string.\nThis actor takes the file to read as input.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("encoding", "encoding", "");
        this.m_OptionManager.add("output-type", "outputType", (Object)OutputType.ARRAY_OF_LINES);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Queue = new ArrayList();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Queue.clear();
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "outputType", (Object)this.m_OutputType);
    }

    @Override
    public void setEncoding(String value) {
        this.m_Encoding = value;
        this.reset();
    }

    @Override
    public String getEncoding() {
        return this.m_Encoding;
    }

    @Override
    public String encodingTipText() {
        return "The type of encoding to use when reading the file, use empty string for default.";
    }

    public void setOutputType(OutputType value) {
        this.m_OutputType = value;
        this.reset();
    }

    public OutputType getOutputType() {
        return this.m_OutputType;
    }

    public String outputTypeTipText() {
        return "The output type defines how to forward the content of the text file.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    @Override
    public Class[] generates() {
        switch (this.m_OutputType) {
            case ARRAY_OF_LINES: {
                return new Class[]{String[].class};
            }
            case LINE_BY_LINE: 
            case SINGLE_STRING: {
                return new Class[]{String.class};
            }
        }
        throw new IllegalStateException("Unhandled output type: " + (Object)((Object)this.m_OutputType));
    }

    @Override
    protected String doExecute() {
        boolean ok;
        String result = null;
        Object fileObj = this.m_InputToken.getPayload();
        File file = fileObj instanceof File ? (File)fileObj : new PlaceholderFile((String)fileObj);
        this.m_Queue.clear();
        switch (this.m_OutputType) {
            case ARRAY_OF_LINES: {
                List<String> content = FileUtils.loadFromFile(file, this.m_Encoding);
                boolean bl = ok = content != null;
                if (!ok) break;
                this.m_Queue.add(content.toArray(new String[content.size()]));
                break;
            }
            case LINE_BY_LINE: {
                List<String> content = FileUtils.loadFromFile(file, this.m_Encoding);
                boolean bl = ok = content != null;
                if (!ok) break;
                for (int i = 0; i < content.size(); ++i) {
                    this.m_Queue.add(content.get(i));
                }
                break;
            }
            case SINGLE_STRING: {
                byte[] bytes = FileUtils.loadFromBinaryFile(file);
                boolean bl = ok = bytes != null;
                if (!ok) break;
                try {
                    if (this.m_Encoding.length() > 0) {
                        this.m_Queue.add(new String(bytes, this.m_Encoding));
                        break;
                    }
                    this.m_Queue.add(new String(bytes));
                }
                catch (Exception e) {
                    result = this.handleException("Failed to read using " + this.m_Encoding, e);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled output type: " + (Object)((Object)this.m_OutputType));
            }
        }
        if (!ok) {
            result = "Error reading file: " + file;
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Queue.size() > 0;
    }

    @Override
    public Token output() {
        Token result = new Token(this.m_Queue.get(0));
        this.m_Queue.remove(0);
        this.m_OutputToken = null;
        this.m_InputToken = null;
        return result;
    }

    public static enum OutputType {
        ARRAY_OF_LINES,
        LINE_BY_LINE,
        SINGLE_STRING;

    }
}

