/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.ClassLocator;
import adams.gui.chooser.AbstractExtensionFileFilterFileChooser;
import adams.gui.chooser.ExtensionFileFilterWithClass;
import adams.gui.goe.GenericObjectEditor;
import adams.gui.goe.GenericObjectEditorDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class AbstractConfigurableExtensionFileFilterFileChooser<R, W>
extends AbstractExtensionFileFilterFileChooser<ExtensionFileFilterWithClass> {
    private static final long serialVersionUID = 6245115901277297175L;
    protected JCheckBox m_CheckBoxOptions;
    protected transient GenericObjectEditor m_Editor;

    protected AbstractConfigurableExtensionFileFilterFileChooser() {
    }

    protected AbstractConfigurableExtensionFileFilterFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    protected AbstractConfigurableExtensionFileFilterFileChooser(String currentDirectory) {
        super(currentDirectory);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Editor = null;
        this.setAutoAppendExtension(true);
        this.setAllowGlobFilters(false);
    }

    protected synchronized GenericObjectEditor getEditor() {
        if (this.m_Editor == null) {
            this.m_Editor = new GenericObjectEditor(false);
        }
        return this.m_Editor;
    }

    @Override
    protected JComponent createAccessoryPanel() {
        super.createAccessoryPanel();
        this.m_CheckBoxOptions = new JCheckBox("Edit options");
        this.m_CheckBoxOptions.setMnemonic('E');
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)this.m_CheckBoxOptions, "North");
        result.add((Component)this.m_PanelBookmarks, "Center");
        return result;
    }

    @Override
    protected abstract boolean getFiltersInitialized();

    @Override
    protected abstract void doInitializeFilters();

    @Override
    protected abstract List<ExtensionFileFilterWithClass> getOpenFileFilters();

    @Override
    protected abstract List<ExtensionFileFilterWithClass> getSaveFileFilters();

    @Override
    protected ExtensionFileFilterWithClass getDefaultFileFilter(int dialogType) {
        List<ExtensionFileFilterWithClass> list;
        ExtensionFileFilterWithClass result = null;
        String cls = null;
        if (dialogType == 0) {
            list = this.getOpenFileFilters();
            if (this.getDefaultReader() != null) {
                cls = this.getDefaultReader().getClass().getName();
            }
        } else {
            list = this.getSaveFileFilters();
            if (this.getDefaultWriter() != null) {
                cls = this.getDefaultWriter().getClass().getName();
            }
        }
        if (list.size() > 0 && cls != null) {
            for (ExtensionFileFilterWithClass ext : list) {
                if (!ext.getClassname().equals(cls)) continue;
                result = ext;
                break;
            }
        }
        return result;
    }

    @Override
    protected void initGUI(int dialogType) {
        super.initGUI(dialogType);
        if (dialogType == 0) {
            this.getEditor().setClassType(this.getReaderClass());
            this.getEditor().setValue(this.getDefaultReader());
        } else {
            this.getEditor().setClassType(this.getWriterClass());
            this.getEditor().setValue(this.getDefaultWriter());
        }
        this.restoreLastFilter(dialogType);
    }

    protected abstract R getDefaultReader();

    protected abstract Class getReaderClass();

    protected abstract W getDefaultWriter();

    protected abstract Class getWriterClass();

    public R getReader() {
        this.configureCurrentHandlerHook(0);
        if (!ClassLocator.isSubclass(this.getReaderClass(), this.m_CurrentHandler.getClass()) && !ClassLocator.hasInterface(this.getReaderClass(), this.m_CurrentHandler.getClass())) {
            return null;
        }
        return (R)this.m_CurrentHandler;
    }

    public W getWriter() {
        this.configureCurrentHandlerHook(1);
        if (!ClassLocator.isSubclass(this.getWriterClass(), this.m_CurrentHandler.getClass()) && !ClassLocator.hasInterface(this.getWriterClass(), this.m_CurrentHandler.getClass())) {
            return null;
        }
        return (W)this.m_CurrentHandler;
    }

    @Override
    public int showOpenDialog(Component parent) {
        int result = super.showOpenDialog(parent);
        if (result == 0 && this.m_CheckBoxOptions.isSelected()) {
            this.getEditor().setValue(this.m_CurrentHandler);
            GenericObjectEditorDialog dialog = GenericObjectEditorDialog.createDialog(this, this.getEditor());
            dialog.setVisible(true);
            result = dialog.getResultType();
            if (result == 0) {
                this.m_CurrentHandler = this.getEditor().getValue();
            }
        }
        return result;
    }

    @Override
    public int showSaveDialog(Component parent) {
        int result = super.showSaveDialog(parent);
        if (result == 0 && this.m_CheckBoxOptions.isSelected()) {
            this.getEditor().setValue(this.m_CurrentHandler);
            GenericObjectEditorDialog dialog = GenericObjectEditorDialog.createDialog(this, this.getEditor());
            dialog.setVisible(true);
            result = dialog.getResultType();
            if (result == 0) {
                this.m_CurrentHandler = this.getEditor().getValue();
            }
        }
        return result;
    }

    @Override
    protected void updateCurrentHandlerHook() {
        if (this.isGlobFilter(this.getFileFilter())) {
            return;
        }
        try {
            String classname = ((ExtensionFileFilterWithClass)this.getFileFilter()).getClassname();
            Object newHandler = Class.forName(classname).newInstance();
            if (this.m_CurrentHandler == null) {
                this.m_CurrentHandler = newHandler;
            } else if (!this.m_CurrentHandler.getClass().equals(newHandler.getClass())) {
                this.m_CurrentHandler = newHandler;
            }
            this.setFileSelectionMode(0);
        }
        catch (Exception e) {
            this.m_CurrentHandler = null;
            e.printStackTrace();
        }
    }

    @Override
    protected void configureCurrentHandlerHook(int dialogType) {
        if (this.m_CurrentHandler == null) {
            String classname = ((ExtensionFileFilterWithClass)this.getFileFilter()).getClassname();
            try {
                this.m_CurrentHandler = Class.forName(classname).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.m_CurrentHandler = null;
            }
            if (this.m_CurrentHandler == null) {
                return;
            }
        }
    }
}

