/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.Properties;
import adams.core.io.PlaceholderDirectory;
import adams.env.Environment;
import adams.gui.core.BaseList;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FileChooserBookmarksPanel
extends BasePanel {
    private static final long serialVersionUID = -1969362821325599909L;
    public static final String FILENAME = "FileChooserBookmarks.props";
    public static final String BOOKMARK_COUNT = "BookmarkCount";
    public static final String BOOKMARK_PREFIX_NAME = "BookmarkName.";
    public static final String BOOKMARK_PREFIX_DIR = "BookmarkDir.";
    protected static Properties m_Properties;
    protected JFileChooser m_Owner;
    protected BaseList m_ListBookmarks;
    protected DefaultListModel m_ModelBookmarks;
    protected JPanel m_PanelButtons;
    protected JButton m_ButtonAdd;
    protected JButton m_ButtonRemove;
    protected JButton m_ButtonMoveUp;
    protected JButton m_ButtonMoveDown;
    protected PropertyChangeListener m_DirChangeListener;
    protected boolean m_SkipDirectoryChanges;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_DirChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("directoryChanged") && !FileChooserBookmarksPanel.this.m_SkipDirectoryChanges) {
                    FileChooserBookmarksPanel.this.m_ListBookmarks.clearSelection();
                }
            }
        };
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_ModelBookmarks = this.loadBookmarks();
        this.m_ListBookmarks = new BaseList((ListModel)this.m_ModelBookmarks);
        this.m_ListBookmarks.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isRightClick(e)) {
                    JPopupMenu menu = FileChooserBookmarksPanel.this.getPopupMenu(e);
                    if (menu != null) {
                        menu.show(FileChooserBookmarksPanel.this.m_ListBookmarks, e.getX(), e.getY());
                    }
                } else {
                    super.mouseClicked(e);
                }
            }
        });
        this.m_ListBookmarks.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FileChooserBookmarksPanel.this.updateButtons();
                if (FileChooserBookmarksPanel.this.m_Owner == null) {
                    return;
                }
                if (FileChooserBookmarksPanel.this.m_ListBookmarks.getSelectedIndices().length != 1) {
                    return;
                }
                Bookmark bookmark = (Bookmark)FileChooserBookmarksPanel.this.m_ListBookmarks.getSelectedValue();
                if (!bookmark.getDirectory().exists()) {
                    return;
                }
                FileChooserBookmarksPanel.this.m_SkipDirectoryChanges = true;
                FileChooserBookmarksPanel.this.m_Owner.setCurrentDirectory(bookmark.getDirectory().getAbsoluteFile());
                FileChooserBookmarksPanel.this.m_Owner.ensureFileIsVisible(bookmark.getDirectory().getAbsoluteFile());
                FileChooserBookmarksPanel.this.m_SkipDirectoryChanges = false;
            }
        });
        this.add((Component)new BaseScrollPane(this.m_ListBookmarks), "Center");
        this.m_PanelButtons = new JPanel(new FlowLayout(0));
        this.add((Component)this.m_PanelButtons, "South");
        this.m_ButtonAdd = new JButton(GUIHelper.getIcon("add.gif"));
        this.m_ButtonAdd.setContentAreaFilled(false);
        this.m_ButtonAdd.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.m_ButtonAdd.setBackground(this.getBackground());
        this.m_ButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserBookmarksPanel.this.addBookmark();
            }
        });
        this.m_PanelButtons.add(this.m_ButtonAdd);
        this.m_ButtonRemove = new JButton(GUIHelper.getIcon("remove.gif"));
        this.m_ButtonRemove.setContentAreaFilled(false);
        this.m_ButtonRemove.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.m_ButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserBookmarksPanel.this.removeBookmark(FileChooserBookmarksPanel.this.m_ListBookmarks.getSelectedIndices());
            }
        });
        this.m_PanelButtons.add(this.m_ButtonRemove);
        this.m_ButtonMoveUp = new JButton(GUIHelper.getIcon("arrow_up.gif"));
        this.m_ButtonMoveUp.setContentAreaFilled(false);
        this.m_ButtonMoveUp.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.m_ButtonMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FileChooserBookmarksPanel.this.m_ListBookmarks.canMoveUp()) {
                    FileChooserBookmarksPanel.this.m_ListBookmarks.moveUp();
                }
                FileChooserBookmarksPanel.this.saveBookmarks(FileChooserBookmarksPanel.this.m_ModelBookmarks);
            }
        });
        this.m_PanelButtons.add(this.m_ButtonMoveUp);
        this.m_ButtonMoveDown = new JButton(GUIHelper.getIcon("arrow_down.gif"));
        this.m_ButtonMoveDown.setContentAreaFilled(false);
        this.m_ButtonMoveDown.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.m_ButtonMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FileChooserBookmarksPanel.this.m_ListBookmarks.canMoveDown()) {
                    FileChooserBookmarksPanel.this.m_ListBookmarks.moveDown();
                }
                FileChooserBookmarksPanel.this.saveBookmarks(FileChooserBookmarksPanel.this.m_ModelBookmarks);
            }
        });
        this.m_PanelButtons.add(this.m_ButtonMoveDown);
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.updateButtons();
    }

    public void setOwner(JFileChooser value) {
        if (this.m_Owner != null) {
            this.m_Owner.removePropertyChangeListener(this.m_DirChangeListener);
        }
        this.m_Owner = value;
        this.m_Owner.addPropertyChangeListener(this.m_DirChangeListener);
    }

    public JFileChooser getOwner() {
        return this.m_Owner;
    }

    protected JPopupMenu getPopupMenu(MouseEvent e) {
        if (this.m_Owner == null) {
            return null;
        }
        JPopupMenu result = new JPopupMenu();
        final int[] indices = this.m_ListBookmarks.getSelectedIndices();
        JMenuItem menuitem = new JMenuItem("Remove", GUIHelper.getIcon("remove.gif"));
        menuitem.setEnabled(indices.length > 0);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserBookmarksPanel.this.removeBookmark(indices);
            }
        });
        result.add(menuitem);
        menuitem = new JMenuItem("Rename", GUIHelper.getEmptyIcon());
        menuitem.setEnabled(indices.length == 1);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserBookmarksPanel.this.renameBookmark(indices[0]);
            }
        });
        result.add(menuitem);
        return result;
    }

    protected Bookmark createUniqueBookmark(Bookmark bookmark, DefaultListModel model) {
        Bookmark result = bookmark;
        int count = 1;
        while (model.contains(result)) {
            result = new Bookmark(bookmark.getName() + ++count, bookmark.getDirectory());
        }
        return result;
    }

    protected void addBookmark() {
        Bookmark bookmark;
        if (this.m_Owner == null) {
            ConsolePanel.getSingleton().append(ConsolePanel.OutputType.ERROR, "No owner set, cannot add boookmark!");
            return;
        }
        File[] files = this.m_Owner.getSelectedFiles();
        boolean added = false;
        for (File file : files) {
            if (!file.isDirectory()) continue;
            added = true;
            bookmark = new Bookmark(new PlaceholderDirectory(file));
            this.m_ModelBookmarks.addElement(this.createUniqueBookmark(bookmark, this.m_ModelBookmarks));
        }
        if (!added) {
            bookmark = new Bookmark(new PlaceholderDirectory(this.m_Owner.getCurrentDirectory()));
            this.m_ModelBookmarks.addElement(this.createUniqueBookmark(bookmark, this.m_ModelBookmarks));
        }
        this.saveBookmarks(this.m_ModelBookmarks);
    }

    protected void removeBookmark(int[] indices) {
        Arrays.sort(indices);
        for (int i = indices.length - 1; i >= 0; --i) {
            this.m_ModelBookmarks.remove(indices[i]);
        }
        this.saveBookmarks(this.m_ModelBookmarks);
    }

    protected void renameBookmark(int index) {
        Bookmark bookmark = (Bookmark)this.m_ModelBookmarks.get(index);
        String name = JOptionPane.showInputDialog(GUIHelper.getParentComponent(this), "Please enter a new name:", bookmark.getName());
        if (name == null || name.equals(bookmark.getName())) {
            return;
        }
        this.m_ModelBookmarks.set(index, new Bookmark(name, bookmark.getDirectory()));
        this.saveBookmarks(this.m_ModelBookmarks);
    }

    protected DefaultListModel loadBookmarks() {
        DefaultListModel<Bookmark> result = new DefaultListModel<Bookmark>();
        Properties props = FileChooserBookmarksPanel.getProperties();
        int count = props.getInteger(BOOKMARK_COUNT, 0);
        for (int i = 0; i < count; ++i) {
            String name = props.getProperty(BOOKMARK_PREFIX_NAME + i);
            PlaceholderDirectory dir = new PlaceholderDirectory(props.getPath(BOOKMARK_PREFIX_DIR + i));
            Bookmark bookmark = new Bookmark(name, dir);
            result.addElement(bookmark);
        }
        return result;
    }

    protected boolean saveBookmarks(DefaultListModel model) {
        Properties props = FileChooserBookmarksPanel.getProperties();
        props.clear();
        props.setInteger(BOOKMARK_COUNT, model.getSize());
        for (int i = 0; i < model.getSize(); ++i) {
            Bookmark bookmark = (Bookmark)model.get(i);
            props.setProperty(BOOKMARK_PREFIX_NAME + i, bookmark.getName());
            props.setPath(BOOKMARK_PREFIX_DIR + i, bookmark.getDirectory().getAbsolutePath());
        }
        return props.save(Environment.getInstance().createPropertiesFilename(FILENAME));
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension result = (Dimension)super.getPreferredSize().clone();
        if (result.getWidth() > (double)this.m_PanelButtons.getPreferredSize().width) {
            result.width = this.m_PanelButtons.getPreferredSize().width;
        }
        return result;
    }

    protected void updateButtons() {
        boolean hasBookmarks = this.m_ModelBookmarks.getSize() > 0;
        this.m_ButtonAdd.setEnabled(true);
        this.m_ButtonMoveUp.setEnabled(hasBookmarks && this.m_ListBookmarks.canMoveUp());
        this.m_ButtonMoveDown.setEnabled(hasBookmarks && this.m_ListBookmarks.canMoveDown());
        this.m_ButtonRemove.setEnabled(hasBookmarks && this.m_ListBookmarks.getSelectedIndices().length > 0);
    }

    protected static synchronized Properties getProperties() {
        if (m_Properties == null) {
            try {
                m_Properties = Properties.read(FILENAME);
            }
            catch (Exception e) {
                m_Properties = new Properties();
            }
        }
        return m_Properties;
    }

    public static class Bookmark
    implements Serializable,
    Comparable<Bookmark> {
        private static final long serialVersionUID = 4284430561284693010L;
        protected String m_Name;
        protected PlaceholderDirectory m_Directory;

        public Bookmark(PlaceholderDirectory dir) {
            this(dir.getAbsoluteFile().getName(), dir);
        }

        public Bookmark(String name, PlaceholderDirectory dir) {
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("Name cannot be null or empty!");
            }
            if (dir == null) {
                throw new IllegalArgumentException("Directory cannot be null!");
            }
            this.m_Name = name;
            this.m_Directory = dir;
        }

        public String getName() {
            return this.m_Name;
        }

        public PlaceholderDirectory getDirectory() {
            return this.m_Directory;
        }

        @Override
        public int compareTo(Bookmark o) {
            return this.getName().compareTo(o.getName());
        }

        public boolean equals(Object obj) {
            if (obj instanceof Bookmark) {
                return this.compareTo((Bookmark)obj) == 0;
            }
            return false;
        }

        public String toString() {
            return this.m_Name;
        }
    }
}

