/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.gui.chooser.AbstractExtensionFileFilterFileChooser;
import adams.gui.chooser.ImagePreview;
import adams.gui.core.ExtensionFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ImageFileChooser
extends AbstractExtensionFileFilterFileChooser<ExtensionFileFilter> {
    private static final long serialVersionUID = -4519042048473978377L;
    protected JCheckBox m_CheckBoxPreview;
    protected ImagePreview m_ImagePreview;
    protected static Hashtable<String, ImageFormat> m_ImageReaders;
    protected static Hashtable<String, ImageFormat> m_ImageWriters;

    public ImageFileChooser() {
    }

    public ImageFileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
    }

    public ImageFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    @Override
    protected JComponent createAccessoryPanel() {
        super.createAccessoryPanel();
        this.m_CheckBoxPreview = new JCheckBox("Preview");
        this.m_CheckBoxPreview.setMnemonic('P');
        this.m_CheckBoxPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageFileChooser.this.m_ImagePreview.setVisible(ImageFileChooser.this.m_CheckBoxPreview.isSelected());
            }
        });
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)this.m_CheckBoxPreview, "North");
        JPanel panel = new JPanel(new BorderLayout());
        result.add((Component)panel, "Center");
        this.m_ImagePreview = new ImagePreview(this);
        panel.add((Component)this.m_PanelBookmarks, "Center");
        panel.add((Component)this.m_ImagePreview, "South");
        return result;
    }

    @Override
    protected List<ExtensionFileFilter> getOpenFileFilters() {
        ArrayList<ExtensionFileFilter> result = new ArrayList<ExtensionFileFilter>();
        ArrayList<String> keys = new ArrayList<String>(m_ImageReaders.keySet());
        for (String key : keys) {
            ImageFormat format = m_ImageReaders.get(key);
            result.add(new ExtensionFileFilter(format.getDisplayName(), format.getExtensions().toArray(new String[0])));
        }
        Collections.sort(result);
        return result;
    }

    @Override
    protected List<ExtensionFileFilter> getSaveFileFilters() {
        ArrayList<ExtensionFileFilter> result = new ArrayList<ExtensionFileFilter>();
        ArrayList<String> keys = new ArrayList<String>(m_ImageWriters.keySet());
        for (String key : keys) {
            ImageFormat format = m_ImageWriters.get(key);
            result.add(new ExtensionFileFilter(format.getDisplayName(), format.getExtensions().toArray(new String[0])));
        }
        Collections.sort(result);
        return result;
    }

    @Override
    protected void updateCurrentHandlerHook() {
        try {
            Object newHandler = null;
            String suffix = ((ExtensionFileFilter)this.getFileFilter()).getExtensions()[0];
            Iterator<Object> iter = this.m_DialogType == 0 ? ImageIO.getImageReadersBySuffix(suffix) : ImageIO.getImageWritersBySuffix(suffix);
            if (iter.hasNext()) {
                newHandler = iter.next();
            }
            if (newHandler == null) {
                return;
            }
            if (this.m_CurrentHandler == null) {
                this.m_CurrentHandler = newHandler;
            } else if (!this.m_CurrentHandler.getClass().equals(newHandler.getClass())) {
                this.m_CurrentHandler = newHandler;
            }
        }
        catch (Exception e) {
            this.m_CurrentHandler = null;
            e.printStackTrace();
        }
    }

    public ImageReader getImageReader() {
        this.configureCurrentHandlerHook(0);
        if (this.m_CurrentHandler instanceof ImageReader) {
            return (ImageReader)this.m_CurrentHandler;
        }
        return null;
    }

    public ImageWriter getImageWriter() {
        this.configureCurrentHandlerHook(0);
        if (this.m_CurrentHandler instanceof ImageWriter) {
            return (ImageWriter)this.m_CurrentHandler;
        }
        return null;
    }

    @Override
    protected boolean getFiltersInitialized() {
        return m_ImageReaders != null;
    }

    @Override
    protected void doInitializeFilters() {
        int i;
        m_ImageReaders = new Hashtable();
        m_ImageWriters = new Hashtable();
        String[] suffixes = ImageIO.getReaderFileSuffixes();
        for (i = 0; i < suffixes.length; ++i) {
            Iterator<ImageReader> readers = ImageIO.getImageReadersBySuffix(suffixes[i]);
            while (readers.hasNext()) {
                ImageReader reader = readers.next();
                try {
                    String formatName = reader.getFormatName();
                    if (!m_ImageReaders.containsKey(formatName)) {
                        m_ImageReaders.put(formatName, new ImageFormat(formatName));
                    }
                    m_ImageReaders.get(formatName).addExtension(suffixes[i]);
                }
                catch (Exception e) {}
            }
        }
        suffixes = ImageIO.getWriterFileSuffixes();
        for (i = 0; i < suffixes.length; ++i) {
            String formatName = ImageFileChooser.getReaderFormatName(suffixes[i]);
            if (formatName == null) continue;
            if (!m_ImageWriters.containsKey(formatName)) {
                m_ImageWriters.put(formatName, new ImageFormat(formatName));
            }
            m_ImageWriters.get(formatName).addExtension(suffixes[i]);
        }
    }

    public static String getReaderFormatName(File file) {
        return ImageFileChooser.getReaderFormatName(file.getName().replaceAll(".*\\.", ""));
    }

    public static String getReaderFormatName(String suffix) {
        String result = null;
        for (String format : m_ImageReaders.keySet()) {
            List<String> exts = m_ImageReaders.get(format).getExtensions();
            for (String ext : exts) {
                if (!ext.equals(suffix)) continue;
                result = format;
                break;
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    public static String getWriterFormatName(File file) {
        return ImageFileChooser.getWriterFormatName(file.getName().replaceAll(".*\\.", ""));
    }

    public static String getWriterFormatName(String suffix) {
        String result = null;
        for (String format : m_ImageWriters.keySet()) {
            List<String> exts = m_ImageWriters.get(format).getExtensions();
            for (String ext : exts) {
                if (!ext.equals(suffix)) continue;
                result = format;
                break;
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    public static class ImageFormat
    implements Comparable<ImageFormat> {
        protected String m_FormatName;
        protected String m_DisplayName;
        protected List<String> m_Extensions;

        public ImageFormat(String format) {
            this(format, format.toUpperCase() + " image");
        }

        public ImageFormat(String format, String display) {
            this.m_FormatName = format;
            this.m_DisplayName = display;
            this.m_Extensions = new ArrayList<String>();
        }

        public String getFormatName() {
            return this.m_FormatName;
        }

        public String getDisplayName() {
            return this.m_DisplayName;
        }

        public void addExtension(String value) {
            if (!this.m_Extensions.contains(value)) {
                this.m_Extensions.add(value);
                Collections.sort(this.m_Extensions);
            }
        }

        public List<String> getExtensions() {
            return this.m_Extensions;
        }

        @Override
        public int compareTo(ImageFormat o) {
            return this.m_FormatName.toLowerCase().compareTo(o.getFormatName().toLowerCase());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ImageFormat)) {
                return false;
            }
            return this.compareTo((ImageFormat)obj) == 0;
        }

        public int hashCode() {
            return this.m_FormatName.hashCode();
        }

        public String toString() {
            return "format=" + this.getFormatName() + ", " + "display=" + this.getDisplayName() + ", " + "ext=" + this.getExtensions();
        }
    }
}

