/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.io.output.AbstractSpreadSheetWriter;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.gui.chooser.AbstractConfigurableExtensionFileFilterFileChooser;
import adams.gui.chooser.ExtensionFileFilterWithClass;
import adams.gui.chooser.FileTypeDeterminingFileChooser;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SpreadSheetFileChooser
extends AbstractConfigurableExtensionFileFilterFileChooser<SpreadSheetReader, SpreadSheetWriter>
implements FileTypeDeterminingFileChooser<SpreadSheetReader, SpreadSheetWriter> {
    private static final long serialVersionUID = -6341967475735162796L;
    protected static List<ExtensionFileFilterWithClass> m_ReaderFileFilters;
    protected static List<ExtensionFileFilterWithClass> m_WriterFileFilters;

    public SpreadSheetFileChooser() {
    }

    public SpreadSheetFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    public SpreadSheetFileChooser(String currentDirectory) {
        super(currentDirectory);
    }

    @Override
    protected boolean getFiltersInitialized() {
        return m_ReaderFileFilters != null;
    }

    @Override
    protected void doInitializeFilters() {
        SpreadSheetFileChooser.initFilters(true, AbstractSpreadSheetReader.getReaders());
        SpreadSheetFileChooser.initFilters(false, AbstractSpreadSheetWriter.getWriters());
    }

    protected static void initFilters(boolean reader, String[] classnames) {
        if (reader) {
            m_ReaderFileFilters = new ArrayList<ExtensionFileFilterWithClass>();
        } else {
            m_WriterFileFilters = new ArrayList<ExtensionFileFilterWithClass>();
        }
        for (int i = 0; i < classnames.length; ++i) {
            ExtensionFileFilterWithClass filter;
            String[] ext;
            String desc;
            Object converter;
            Class<?> cls;
            String classname = classnames[i];
            try {
                cls = Class.forName(classname);
                converter = cls.newInstance();
                if (reader) {
                    desc = ((SpreadSheetReader)converter).getFormatDescription();
                    ext = ((SpreadSheetReader)converter).getFormatExtensions();
                } else {
                    desc = ((SpreadSheetWriter)converter).getFormatDescription();
                    ext = ((SpreadSheetWriter)converter).getFormatExtensions();
                }
            }
            catch (Exception e) {
                System.err.println("Failed to set up '" + classname + "':");
                e.printStackTrace();
                cls = null;
                converter = null;
                ext = new String[]{};
                desc = "";
            }
            if (converter == null) continue;
            if (reader) {
                filter = new ExtensionFileFilterWithClass(classname, desc, ext);
                m_ReaderFileFilters.add(filter);
                continue;
            }
            filter = new ExtensionFileFilterWithClass(classname, desc, ext);
            m_WriterFileFilters.add(filter);
        }
        if (reader) {
            Collections.sort(m_ReaderFileFilters);
        } else {
            Collections.sort(m_WriterFileFilters);
        }
    }

    @Override
    protected List<ExtensionFileFilterWithClass> getOpenFileFilters() {
        return m_ReaderFileFilters;
    }

    @Override
    protected List<ExtensionFileFilterWithClass> getSaveFileFilters() {
        return m_WriterFileFilters;
    }

    @Override
    protected Class getReaderClass() {
        return SpreadSheetReader.class;
    }

    @Override
    protected Class getWriterClass() {
        return SpreadSheetWriter.class;
    }

    @Override
    protected SpreadSheetReader getDefaultReader() {
        return new CsvSpreadSheetReader();
    }

    @Override
    protected SpreadSheetWriter getDefaultWriter() {
        return new CsvSpreadSheetWriter();
    }

    @Override
    public SpreadSheetReader getReaderForFile(File file) {
        SpreadSheetReader result = null;
        for (ExtensionFileFilterWithClass filter : m_ReaderFileFilters) {
            if (!filter.accept(file)) continue;
            try {
                result = (SpreadSheetReader)Class.forName(filter.getClassname()).newInstance();
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate reader '" + filter.getClassname() + "':");
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public SpreadSheetWriter getWriterForFile(File file) {
        SpreadSheetWriter result = null;
        for (ExtensionFileFilterWithClass filter : m_WriterFileFilters) {
            if (!filter.accept(file)) continue;
            try {
                result = (SpreadSheetWriter)Class.forName(filter.getClassname()).newInstance();
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate writer '" + filter.getClassname() + "':");
                e.printStackTrace();
            }
        }
        return result;
    }
}

