/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.Properties;
import adams.core.logging.LoggingObject;
import adams.env.Environment;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class AbstractRecentItemsHandler<M, T>
extends LoggingObject {
    private static final long serialVersionUID = 7532226757387619342L;
    protected String m_PropertiesFile;
    protected String m_PropertyPrefix;
    protected int m_MaxCount;
    protected M m_Menu;
    protected List<T> m_RecentItems;
    protected boolean m_IgnoreChanges;
    protected HashSet<RecentItemListener<M, T>> m_Listeners;

    public AbstractRecentItemsHandler(String propsFile, M menu) {
        this(propsFile, 5, menu);
    }

    public AbstractRecentItemsHandler(String propsFile, int maxCount, M menu) {
        this(propsFile, null, maxCount, menu);
    }

    public AbstractRecentItemsHandler(String propsFile, String propPrefix, int maxCount, M menu) {
        if (!(menu instanceof JMenu) && !(menu instanceof JPopupMenu)) {
            throw new IllegalArgumentException("Menu must be derived from " + JMenu.class.getName() + " or " + JPopupMenu.class.getName() + ", provided: " + menu.getClass().getName());
        }
        this.m_PropertiesFile = Environment.getInstance().getHome() + File.separator + new File(propsFile).getName();
        this.m_PropertyPrefix = propPrefix;
        this.m_MaxCount = maxCount;
        this.m_Menu = menu;
        this.m_RecentItems = new ArrayList<T>();
        this.m_IgnoreChanges = false;
        this.m_Listeners = new HashSet();
        this.readProps();
        this.updateMenu();
    }

    public String getPropertiesFile() {
        return this.m_PropertiesFile;
    }

    public String getPropertyPrefix() {
        return this.m_PropertyPrefix;
    }

    public int getMaxCount() {
        return this.m_MaxCount;
    }

    public M getMenu() {
        return this.m_Menu;
    }

    protected abstract String getCountKey();

    protected abstract String getItemPrefix();

    protected abstract String toString(T var1);

    protected abstract T fromString(String var1);

    protected String expand(String property) {
        if (this.m_PropertyPrefix == null) {
            return property;
        }
        return this.m_PropertyPrefix + property;
    }

    protected Properties loadProps() {
        Properties result;
        try {
            result = new Properties();
            File file = new File(this.m_PropertiesFile);
            if (file.exists()) {
                result.load(this.m_PropertiesFile);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load properties: " + this.m_PropertiesFile, e);
            result = new Properties();
        }
        return result;
    }

    protected boolean check(T item) {
        return true;
    }

    protected void readProps() {
        this.m_IgnoreChanges = true;
        Properties props = this.loadProps();
        int count = props.getInteger(this.expand(this.getCountKey()), 0);
        this.m_RecentItems.clear();
        for (int i = count - 1; i >= 0; --i) {
            T item;
            String itemStr = props.getPath(this.expand(this.getItemPrefix() + i), "");
            if (itemStr.length() <= 0 || !this.check(item = this.fromString(itemStr))) continue;
            this.addRecentItem(item);
        }
        this.m_IgnoreChanges = false;
    }

    protected synchronized void writeProps() {
        Properties props = this.loadProps();
        props.setInteger(this.expand(this.getCountKey()), this.m_RecentItems.size());
        for (int i = 0; i < this.m_RecentItems.size(); ++i) {
            props.setProperty(this.expand(this.getItemPrefix() + i), this.toString(this.m_RecentItems.get(i)));
        }
        try {
            props.save(this.m_PropertiesFile);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to write properties: " + this.m_PropertiesFile, e);
        }
    }

    protected void preUpdateMenu() {
    }

    protected abstract String createMenuItemText(int var1, T var2);

    protected void doUpdateMenu() {
        if (this.m_Menu instanceof JMenu) {
            ((JMenu)this.m_Menu).removeAll();
            ((JMenu)this.m_Menu).setEnabled(this.m_RecentItems.size() > 0);
        } else if (this.m_Menu instanceof JPopupMenu) {
            ((JPopupMenu)this.m_Menu).removeAll();
            ((JPopupMenu)this.m_Menu).setEnabled(this.m_RecentItems.size() > 0);
        }
        for (int i = 0; i < this.m_RecentItems.size(); ++i) {
            final T item = this.m_RecentItems.get(i);
            JMenuItem menuitem = new JMenuItem(i + 1 + " - " + this.createMenuItemText(i, item));
            if (i < 9) {
                menuitem.setMnemonic(Integer.toString(i + 1).charAt(0));
            }
            if (i == 10) {
                menuitem.setMnemonic('0');
            }
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractRecentItemsHandler.this.notifyRecentItemListenersOfSelect(item);
                }
            });
            if (this.m_Menu instanceof JMenu) {
                ((JMenu)this.m_Menu).add(menuitem);
                continue;
            }
            if (!(this.m_Menu instanceof JPopupMenu)) continue;
            ((JPopupMenu)this.m_Menu).add(menuitem);
        }
    }

    protected void postUpdateMenu() {
    }

    protected void updateMenu() {
        this.preUpdateMenu();
        this.doUpdateMenu();
        this.postUpdateMenu();
    }

    public synchronized void addRecentItem(T item) {
        item = this.fromString(this.toString(item));
        if (this.m_RecentItems.size() > 0 && item.equals(this.m_RecentItems.get(0))) {
            return;
        }
        this.m_RecentItems.remove(item);
        this.m_RecentItems.add(0, item);
        while (this.m_RecentItems.size() > this.m_MaxCount) {
            this.m_RecentItems.remove(this.m_RecentItems.size() - 1);
        }
        if (this.m_IgnoreChanges) {
            return;
        }
        this.writeProps();
        this.updateMenu();
        this.notifyRecentItemListenersOfAdd(item);
    }

    public synchronized void removeRecentItem(T item) {
        item = this.fromString(this.toString(item));
        this.m_RecentItems.remove(item);
        if (this.m_IgnoreChanges) {
            return;
        }
        this.writeProps();
        this.updateMenu();
    }

    public List<T> getRecentItems() {
        return new ArrayList<T>(this.m_RecentItems);
    }

    public int size() {
        return this.m_RecentItems.size();
    }

    public void addRecentItemListener(RecentItemListener l) {
        this.m_Listeners.add(l);
    }

    public void removeRecentItemListener(RecentItemListener l) {
        this.m_Listeners.remove(l);
    }

    protected void notifyRecentItemListenersOfAdd(T item) {
        RecentItemEvent e = new RecentItemEvent(this, item);
        Iterator<RecentItemListener<M, T>> iter = this.m_Listeners.iterator();
        while (iter.hasNext()) {
            iter.next().recentItemAdded(e);
        }
    }

    protected void notifyRecentItemListenersOfSelect(T item) {
        RecentItemEvent e = new RecentItemEvent(this, item);
        Iterator<RecentItemListener<M, T>> iter = this.m_Listeners.iterator();
        while (iter.hasNext()) {
            iter.next().recentItemSelected(e);
        }
    }
}

