/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.ClassLocator;
import adams.core.Properties;
import adams.core.Utils;
import adams.core.management.OS;
import adams.core.net.HtmlUtils;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import adams.gui.application.AbstractMenuItemDefinition;
import adams.gui.application.Child;
import adams.gui.core.ErrorMessagePanel;
import adams.gui.core.TransferableImage;
import adams.gui.core.TransferableString;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.dialog.TextPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class GUIHelper {
    public static final String FILENAME = "GUIHelper.props";
    public static final String EMPTY_ICON = "empty.gif";
    public static final char MNEMONIC_INDICATOR = '_';
    public static final int APPROVE_OPTION = 0;
    public static final int DISCARD_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    protected static Properties m_Properties;
    protected static Rectangle m_ScreenBoundaries;

    protected static synchronized void initializeProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("gui helper");
        }
    }

    public static boolean hasImageFile(String name) {
        return GUIHelper.getImageFilename(name) != null;
    }

    public static String getImageFilename(String name) {
        String result = null;
        String[] dirs = GUIHelper.getString("ImagesDirectory", "adams/gui/images/").split(",");
        for (int i = 0; i < dirs.length; ++i) {
            if (!dirs[i].endsWith("/")) {
                int n = i;
                dirs[n] = dirs[n] + "/";
            }
            try {
                URL url = ClassLoader.getSystemClassLoader().getResource(dirs[i] + name);
                if (url == null) continue;
                result = dirs[i] + name;
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public static ImageIcon getIcon(Class cls) {
        if (GUIHelper.hasImageFile(cls.getName() + ".gif")) {
            return GUIHelper.getIcon(cls.getName() + ".gif");
        }
        if (GUIHelper.hasImageFile(cls.getName() + ".png")) {
            return GUIHelper.getIcon(cls.getName() + ".png");
        }
        if (GUIHelper.hasImageFile(cls.getName() + ".jpg")) {
            return GUIHelper.getIcon(cls.getName() + ".jpg");
        }
        return null;
    }

    public static ImageIcon getIcon(String name) {
        String filename = GUIHelper.getImageFilename(name);
        if (filename != null) {
            return new ImageIcon(ClassLoader.getSystemClassLoader().getResource(filename));
        }
        return null;
    }

    public static ImageIcon getExternalIcon(String filename) {
        ImageIcon result;
        try {
            result = new ImageIcon(ClassLoader.getSystemClassLoader().getResource(filename));
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static ImageIcon getEmptyIcon() {
        return GUIHelper.getIcon(EMPTY_ICON);
    }

    public static ImageIcon getLogoImage() {
        ImageIcon result = null;
        String filename = GUIHelper.getString("LogoImage", "");
        if (filename.length() != 0) {
            result = GUIHelper.getIcon(filename);
        }
        return result;
    }

    public static ImageIcon getLogoIcon() {
        ImageIcon result = null;
        String filename = GUIHelper.getString("LogoIcon", "");
        if (filename.length() != 0) {
            result = GUIHelper.getIcon(filename);
        }
        return result;
    }

    public static void setSize(Window window, Component c) {
        GUIHelper.initializeProperties();
        if (c != null) {
            int height;
            int width;
            if (m_Properties.getBoolean(c.getClass().getName() + ".pack", false).booleanValue()) {
                window.pack();
            }
            if ((width = m_Properties.getInteger(c.getClass().getName() + ".width", window.getWidth()).intValue()) == -1) {
                width = window.getGraphicsConfiguration().getBounds().width;
            }
            if ((height = m_Properties.getInteger(c.getClass().getName() + ".height", window.getHeight()).intValue()) == -1) {
                height = window.getGraphicsConfiguration().getBounds().height;
            }
            window.setSize(width, height);
            window.validate();
        }
    }

    public static void setSizeAndLocation(Window window) {
        GUIHelper.setSizeAndLocation(window, null);
    }

    public static int calcLeftPosition(Window window, int left) {
        int result = left == -1 ? (window.getGraphicsConfiguration().getBounds().width - window.getWidth()) / 2 : (left == -2 ? window.getGraphicsConfiguration().getBounds().width : left);
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    public static int calcTopPosition(Window window, int top) {
        int result = top == -1 ? (window.getGraphicsConfiguration().getBounds().height - window.getHeight()) / 2 : (top == -2 ? window.getGraphicsConfiguration().getBounds().height : top);
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    public static void setSizeAndLocation(Window window, Component c) {
        int top;
        int left;
        GUIHelper.initializeProperties();
        GUIHelper.setSize(window, c);
        if (c != null) {
            left = m_Properties.getInteger(c.getClass().getName() + ".left", window.getX());
            left = GUIHelper.calcLeftPosition(window, left);
        } else {
            left = 0;
        }
        if (c != null) {
            top = m_Properties.getInteger(c.getClass().getName() + ".top", window.getY());
            top = GUIHelper.calcTopPosition(window, top);
        } else {
            top = 0;
        }
        GUIHelper.setSizeAndLocation(window, top, left, c);
    }

    public static void setSizeAndLocation(Window window, int top, int left) {
        GUIHelper.setSizeAndLocation(window, top, left, null);
    }

    public static void setSizeAndLocation(Window window, int top, int left, Component c) {
        GUIHelper.initializeProperties();
        GUIHelper.setSize(window, c);
        GUIHelper.adjustSize(window);
        int height = window.getHeight();
        int width = window.getWidth();
        Rectangle screen = GUIHelper.getScreenBounds(window);
        if (left + width > screen.width) {
            left = screen.width - width;
        }
        if (top + height > screen.height) {
            top = screen.height - height;
        }
        window.setLocation(left, top);
    }

    public static synchronized Rectangle getScreenBounds(Window window) {
        if (m_ScreenBoundaries == null) {
            GUIHelper.initializeProperties();
            int top = m_Properties.getInteger("ScreenBorder.Top", 0);
            int left = m_Properties.getInteger("ScreenBorder.Left", 0);
            int bottom = m_Properties.getInteger("ScreenBorder.Bottom", 0);
            int right = m_Properties.getInteger("ScreenBorder.Right", 0);
            int height = window.getGraphicsConfiguration().getBounds().height - top - bottom;
            int width = window.getGraphicsConfiguration().getBounds().width - left - right;
            m_ScreenBoundaries = new Rectangle(left, top, width, height);
        }
        return m_ScreenBoundaries;
    }

    public static void adjustSize(Window window) {
        double percWidth;
        Rectangle screen = GUIHelper.getScreenBounds(window);
        int height = window.getHeight();
        int width = window.getWidth();
        double percHeight = m_Properties.getDouble("MaxWindowHeight", 0.95);
        if (percHeight <= 0.0 || percHeight > 1.0) {
            percHeight = 0.95;
        }
        if ((percWidth = m_Properties.getDouble("MaxWindowWidth", 0.95).doubleValue()) <= 0.0 || percWidth > 1.0) {
            percWidth = 0.95;
        }
        if ((double)height > (double)screen.height * percHeight) {
            height = (int)((double)screen.height * percHeight);
        }
        if ((double)width > (double)screen.width * percWidth) {
            width = (int)((double)screen.width * percWidth);
        }
        window.setSize(width, height);
        window.validate();
    }

    public static File getStartupScript(Component c) {
        String script;
        GUIHelper.initializeProperties();
        File result = null;
        String key = c.getClass().getName() + ".script";
        if (m_Properties.hasKey(key) && !(result = new File(script = m_Properties.getPath(key))).exists()) {
            System.err.println("Startup script '" + script + "' listed for component '" + c.getClass().getName() + "' does not exist - ignored!");
            result = null;
        }
        return result;
    }

    public static String getString(String key, String defValue) {
        GUIHelper.initializeProperties();
        return m_Properties.getProperty(key, defValue);
    }

    public static String getString(Class cls, String key, String defValue) {
        return GUIHelper.getString(cls.getName() + "." + key, defValue);
    }

    public static Integer getInteger(String key, Integer defValue) {
        GUIHelper.initializeProperties();
        return m_Properties.getInteger(key, defValue);
    }

    public static Integer getInteger(Class cls, String key, Integer defValue) {
        return GUIHelper.getInteger(cls.getName() + "." + key, defValue);
    }

    public static Color getColor(String key, Color defValue) {
        GUIHelper.initializeProperties();
        return m_Properties.getColor(key, defValue);
    }

    public static Color getColor(Class cls, String key, Color defValue) {
        return GUIHelper.getColor(cls.getName() + "." + key, defValue);
    }

    public static Double getDouble(String key, Double defValue) {
        GUIHelper.initializeProperties();
        return m_Properties.getDouble(key, defValue);
    }

    public static Double getDouble(Class cls, String key, Double defValue) {
        return GUIHelper.getDouble(cls.getName() + "." + key, defValue);
    }

    public static Boolean getBoolean(String key, Boolean defValue) {
        GUIHelper.initializeProperties();
        return m_Properties.getBoolean(key, defValue);
    }

    public static Boolean getBoolean(Class cls, String key, Boolean defValue) {
        return GUIHelper.getBoolean(cls.getName() + "." + key, defValue);
    }

    public static Font getFont(String key, Font defValue) {
        GUIHelper.initializeProperties();
        return m_Properties.getFont(key, defValue);
    }

    public static Font getFont(Class cls, String key, Font defValue) {
        return GUIHelper.getFont(cls.getName() + "." + key, defValue);
    }

    public static OptionHandler getOptionHandler(String key, OptionHandler defValue) {
        GUIHelper.initializeProperties();
        try {
            return OptionUtils.forCommandLine(OptionHandler.class, m_Properties.getProperty(key, OptionUtils.getCommandLine(defValue)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static OptionHandler getOptionHandler(Class cls, String key, OptionHandler defValue) {
        return GUIHelper.getOptionHandler(cls.getName() + "." + key, defValue);
    }

    public static Object getParent(Container cont, Class parentClass) {
        Container result = null;
        for (Container parent = cont; parent != null; parent = parent.getParent()) {
            if (!parentClass.isInstance(parent)) continue;
            result = parent;
            break;
        }
        return result;
    }

    public static Frame getParentFrame(Container cont) {
        return (Frame)GUIHelper.getParent(cont, Frame.class);
    }

    public static Dialog getParentDialog(Container cont) {
        return (Dialog)GUIHelper.getParent(cont, Dialog.class);
    }

    public static Component getParentComponent(Component comp) {
        if (comp == null) {
            return null;
        }
        if (!(comp instanceof Container)) {
            return null;
        }
        Container cont = (Container)comp;
        Component result = GUIHelper.getParentDialog(cont);
        if (result == null) {
            result = (Component)((Object)GUIHelper.getParentChild(cont));
        }
        if (result == null) {
            result = GUIHelper.getParentFrame(cont);
        }
        return result;
    }

    public static JInternalFrame getParentInternalFrame(Container cont) {
        return (JInternalFrame)GUIHelper.getParent(cont, JInternalFrame.class);
    }

    public static Child getParentChild(Container cont) {
        return (Child)GUIHelper.getParent(cont, Child.class);
    }

    public static void closeParent(Container cont) {
        if (GUIHelper.getParentDialog(cont) != null) {
            Dialog dialog = GUIHelper.getParentDialog(cont);
            dialog.setVisible(false);
        } else if (GUIHelper.getParentFrame(cont) != null) {
            JInternalFrame jintframe = GUIHelper.getParentInternalFrame(cont);
            if (jintframe != null) {
                jintframe.doDefaultCloseAction();
            } else {
                Frame frame = GUIHelper.getParentFrame(cont);
                if (frame instanceof JFrame) {
                    JFrame jframe = (JFrame)frame;
                    if (jframe.getDefaultCloseOperation() == 1) {
                        jframe.setVisible(false);
                    } else if (jframe.getDefaultCloseOperation() == 2) {
                        jframe.dispose();
                    } else if (jframe.getDefaultCloseOperation() == 3) {
                        System.exit(0);
                    }
                    WindowListener[] listeners = jframe.getWindowListeners();
                    WindowEvent event = new WindowEvent(jframe, 202);
                    for (int i = 0; i < listeners.length; ++i) {
                        listeners[i].windowClosed(event);
                    }
                } else {
                    frame.dispose();
                }
            }
        }
    }

    public static void copyToClipboard(Transferable t) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(t, null);
    }

    public static void copyToClipboard(String s) {
        GUIHelper.copyToClipboard(new TransferableString(s));
    }

    public static void copyToClipboard(BufferedImage img) {
        GUIHelper.copyToClipboard(new TransferableImage(img));
    }

    public static boolean canPasteFromClipboard(DataFlavor flavor) {
        boolean result;
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            result = clipboard.isDataFlavorAvailable(flavor);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static boolean canPasteStringFromClipboard() {
        return GUIHelper.canPasteFromClipboard(DataFlavor.stringFlavor);
    }

    public static Object pasteFromClipboard(DataFlavor flavor) {
        Object result = null;
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable content = clipboard.getContents(null);
            if (content != null && content.isDataFlavorSupported(flavor)) {
                result = content.getTransferData(flavor);
            }
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static String pasteStringFromClipboard() {
        String result = null;
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable content = clipboard.getContents(null);
            if (content != null && content.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                result = (String)content.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static String pasteSetupFromClipboard() {
        String[] parts;
        StringBuilder result = new StringBuilder(GUIHelper.pasteStringFromClipboard());
        if (result != null && (parts = result.toString().replaceAll("\r", "").split("\n")).length > 1) {
            String line;
            int i;
            ArrayList<String> lines = new ArrayList<String>();
            for (i = 0; i < parts.length; ++i) {
                line = parts[i].trim();
                if (line.length() == 0) continue;
                lines.add(line);
            }
            boolean formatOK = true;
            for (i = 0; i < lines.size(); ++i) {
                if (i < lines.size() - 1) {
                    formatOK = ((String)lines.get(i)).endsWith("\\");
                } else {
                    boolean bl = formatOK = !((String)lines.get(i)).endsWith("\\");
                }
                if (!formatOK) break;
            }
            if (formatOK) {
                result = new StringBuilder();
                for (i = 0; i < lines.size(); ++i) {
                    if (i > 0) {
                        result.append(" ");
                    }
                    line = (String)lines.get(i);
                    if (i < lines.size() - 1) {
                        line = line.substring(0, ((String)lines.get(i)).length() - 1).trim();
                    }
                    result.append(line);
                }
            }
        }
        return result.toString();
    }

    public static String getLookAndFeel() {
        return GUIHelper.getString("LookAndFeel", UIManager.getCrossPlatformLookAndFeelClassName());
    }

    public static boolean setLookAndFeel(String classname) {
        boolean result;
        try {
            UIManager.setLookAndFeel(classname);
            result = true;
        }
        catch (Exception e) {
            result = false;
            System.err.println("Can't set look & feel:" + e);
        }
        return result;
    }

    public static char[] getMnemonics(String[] labels) {
        char ch;
        int i;
        char[] result = new char[labels.length];
        String allowed = "abdefghijklnpqrstuvwxyz0123456789";
        String[] strLabels = new String[labels.length];
        int numLabels = 0;
        for (i = 0; i < labels.length; ++i) {
            strLabels[i] = labels[i].toLowerCase().replaceAll("[^a-z0-9]", "");
            if (strLabels[i].length() == 0) {
                strLabels[i] = null;
                continue;
            }
            ++numLabels;
        }
        Hashtable charIndices = new Hashtable();
        for (i = 0; i < allowed.length(); ++i) {
            ch = allowed.charAt(i);
            for (int n = 0; n < strLabels.length; ++n) {
                if (strLabels[n] == null || strLabels[n].indexOf(ch) <= -1) continue;
                if (!charIndices.containsKey(Character.valueOf(ch))) {
                    charIndices.put(Character.valueOf(ch), new HashSet());
                }
                ((HashSet)charIndices.get(Character.valueOf(ch))).add(n);
            }
        }
        i = 0;
        HashSet processedIndices = new HashSet();
        do {
            ++i;
            Enumeration enm = charIndices.keys();
            while (enm.hasMoreElements()) {
                ch = ((Character)enm.nextElement()).charValue();
                if (((HashSet)charIndices.get(Character.valueOf(ch))).size() != i) continue;
                for (Integer index : (HashSet)charIndices.get(Character.valueOf(ch))) {
                    if (index < 0 || strLabels[index] == null) continue;
                    result[index.intValue()] = ch;
                    strLabels[index.intValue()] = null;
                }
                processedIndices.addAll((Collection)charIndices.get(Character.valueOf(ch)));
                processedIndices.remove(-1);
            }
        } while (processedIndices.size() != numLabels);
        return result;
    }

    public static boolean hasMnemonic(String caption) {
        return caption.indexOf(95) > -1;
    }

    public static char getMnemonic(String caption) {
        int pos = caption.indexOf(95);
        if (pos > -1 && pos < caption.length() - 1) {
            return caption.charAt(pos + 1);
        }
        return '\u0000';
    }

    public static String stripMnemonic(String caption) {
        return caption.replace("_", "");
    }

    public static void showErrorMessage(Component parent, String msg) {
        GUIHelper.showErrorMessage(parent, msg, "Error");
    }

    public static void showErrorMessage(Component parent, String msg, String title) {
        parent = GUIHelper.getParentComponent(parent);
        String[] lines = msg.split("\n");
        int height = Math.min(350, (lines.length + 1) * 20);
        ApprovalDialog dlg = parent instanceof Frame ? ApprovalDialog.getDialog((Frame)parent, true) : (parent instanceof Dialog ? ApprovalDialog.getDialog((Dialog)parent, Dialog.ModalityType.APPLICATION_MODAL) : ApprovalDialog.getDialog((Dialog)null, Dialog.ModalityType.APPLICATION_MODAL));
        dlg.setTitle(title);
        dlg.setApproveCaption("Close");
        dlg.setApproveMnemonic(108);
        dlg.setCancelVisible(false);
        dlg.setDiscardVisible(false);
        dlg.setDefaultCloseOperation(2);
        dlg.setIconImage(GUIHelper.getIcon("stop.gif").getImage());
        ErrorMessagePanel errorPanel = new ErrorMessagePanel();
        errorPanel.setTitle(title);
        errorPanel.setErrorMessage(msg);
        errorPanel.setLineWrap(false);
        dlg.getButtonsPanel(true).add(errorPanel.getConsoleCheckBox());
        dlg.getContentPane().add((Component)errorPanel, "Center");
        dlg.setJMenuBar(errorPanel.getMenuBar());
        dlg.pack();
        dlg.setSize(600, Math.min(dlg.getHeight() + height, (int)((double)GUIHelper.getScreenBounds((Window)dlg).height * 0.5)));
        errorPanel.setErrorMessage(msg);
        dlg.setLocationRelativeTo(parent);
        dlg.getApproveButton().requestFocusInWindow();
        dlg.setVisible(true);
    }

    public static void showInformationMessage(Component parent, String msg) {
        GUIHelper.showInformationMessage(parent, msg, "Information");
    }

    public static void showInformationMessage(Component parent, String msg, String title) {
        parent = GUIHelper.getParentComponent(parent);
        String[] lines = msg.split("\n");
        int height = Math.min(350, (lines.length + 1) * 20);
        ApprovalDialog dlg = parent instanceof Frame ? ApprovalDialog.getDialog((Frame)parent, true) : (parent instanceof Dialog ? ApprovalDialog.getDialog((Dialog)parent, Dialog.ModalityType.DOCUMENT_MODAL) : ApprovalDialog.getDialog((Dialog)null, Dialog.ModalityType.DOCUMENT_MODAL));
        dlg.setTitle(title);
        dlg.setDefaultCloseOperation(2);
        dlg.setIconImage(GUIHelper.getIcon("information.png").getImage());
        TextPanel editor = new TextPanel();
        editor.setTitle(title);
        editor.setEditable(false);
        editor.setLineWrap(true);
        dlg.getContentPane().add((Component)editor, "Center");
        dlg.pack();
        dlg.setSize(600, Math.min(dlg.getHeight() + height, (int)((double)GUIHelper.getScreenBounds((Window)dlg).height * 0.5)));
        dlg.setLocationRelativeTo(parent);
        editor.setContent(msg);
        dlg.getApproveButton().requestFocusInWindow();
        dlg.setVisible(true);
    }

    public static int showConfirmMessage(Component parent, String msg) {
        return GUIHelper.showConfirmMessage(parent, msg, "Confirm");
    }

    public static int showConfirmMessage(Component parent, String msg, String title) {
        return GUIHelper.showConfirmMessage(parent, null, msg, title);
    }

    public static int showConfirmMessage(Component parent, String header, String msg, String title) {
        parent = GUIHelper.getParentComponent(parent);
        String[] lines = msg.split("\n");
        int height = Math.min(350, (lines.length + 1) * 20);
        ApprovalDialog dlg = parent instanceof Frame ? ApprovalDialog.getConfirmationDialog((Frame)parent, true) : (parent instanceof Dialog ? ApprovalDialog.getConfirmationDialog((Dialog)parent, Dialog.ModalityType.APPLICATION_MODAL) : ApprovalDialog.getConfirmationDialog((Dialog)null, Dialog.ModalityType.APPLICATION_MODAL));
        dlg.setTitle(title);
        dlg.setDefaultCloseOperation(2);
        dlg.setIconImage(GUIHelper.getIcon("question.png").getImage());
        TextPanel editor = new TextPanel();
        editor.setTitle(title);
        editor.setEditable(false);
        editor.setLineWrap(true);
        if (header != null) {
            editor.setInfoText(header);
        }
        dlg.getContentPane().add((Component)editor, "Center");
        dlg.pack();
        dlg.setSize(600, Math.min(dlg.getHeight() + height, (int)((double)GUIHelper.getScreenBounds((Window)dlg).height * 0.5)));
        dlg.setLocationRelativeTo(parent);
        editor.setContent(msg);
        dlg.getCancelButton().requestFocusInWindow();
        dlg.setVisible(true);
        return dlg.getOption();
    }

    public static String processTipText(String text, int width) {
        String result = HtmlUtils.toHTML(text);
        if (result.length() > width) {
            Object[] lines = Utils.breakUp(result, width);
            result = Utils.flatten(lines, "<br>");
        }
        result = "<html>" + result + "</html>";
        return result;
    }

    public static String processKeyStroke(String keystroke) {
        String result = keystroke;
        if (OS.isMac() && (result = result.replace("ctrl", "meta").replace("control", "meta")).indexOf("meta") == -1 && result.indexOf("alt") == -1) {
            result = "meta " + result;
        }
        return result;
    }

    public static KeyStroke getKeyStroke(String keystroke) {
        return KeyStroke.getKeyStroke(GUIHelper.processKeyStroke(keystroke));
    }

    public static Font decodeFont(String s) {
        return Font.decode(s);
    }

    public static String encodeFont(Font f) {
        String face = f.isBold() && f.isItalic() ? "BOLDITALIC" : (f.isBold() ? "BOLD" : (f.isItalic() ? "ITALIC" : "PLAIN"));
        String result = f.getName() + "-" + face + "-" + f.getSize();
        return result;
    }

    public static Font getMonospacedFont() {
        return GUIHelper.getFont("Font.Monospaced", new Font("monospaced", 0, 12));
    }

    protected static void findComponents(Container parent, Class type, boolean recursive, boolean exact, List<Component> list, boolean onlyFirst) {
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component comp = parent.getComponent(i);
            if (exact) {
                if (comp.getClass().equals(type)) {
                    list.add(comp);
                }
            } else if (ClassLocator.isSubclass(type, comp.getClass())) {
                list.add(comp);
            } else if (ClassLocator.hasInterface(type, comp.getClass())) {
                list.add(comp);
            }
            if (onlyFirst && list.size() > 0) {
                return;
            }
            if (!recursive || !(comp instanceof Container)) continue;
            GUIHelper.findComponents((Container)comp, type, recursive, exact, list, onlyFirst);
        }
    }

    public static List<Component> findAllComponents(Container parent, Class type, boolean recursive, boolean exact) {
        ArrayList<Component> result = new ArrayList<Component>();
        GUIHelper.findComponents(parent, type, recursive, exact, result, false);
        return result;
    }

    public static Component findFirstComponent(Container parent, Class type, boolean recursive, boolean exact) {
        ArrayList<Component> result = new ArrayList<Component>();
        GUIHelper.findComponents(parent, type, recursive, exact, result, true);
        if (result.size() == 0) {
            return null;
        }
        return result.get(0);
    }

    public static void configureAntiAliasing(Graphics g, boolean enable) {
        if (enable) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    public static JMenu getTopLevelMenu(JMenuItem menuitem) {
        JMenu result = null;
        JMenuItem prev = null;
        for (Container cont = menuitem; cont != null; cont = cont.getParent()) {
            if (cont instanceof JPopupMenu) {
                result = (JMenu)prev;
                break;
            }
            prev = cont;
        }
        return result;
    }

    public static boolean launchMenuItem(Container source, Class menuitem) {
        Child child = GUIHelper.getParentChild(source);
        if (child == null) {
            return false;
        }
        if (child.getParentFrame() == null) {
            return false;
        }
        try {
            AbstractMenuItemDefinition mitem = (AbstractMenuItemDefinition)menuitem.newInstance();
            mitem.setOwner(child.getParentFrame());
            mitem.launch();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

