/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.io.FileUtils;
import adams.gui.core.AbstractRecentItemsHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;

public class RecentFilesWithEncodingHandler<M>
extends AbstractRecentItemsHandler<M, String> {
    private static final long serialVersionUID = 7532226757387619342L;
    public static final String RECENTFILES_COUNT = "RecentFilesCount";
    public static final String RECENTFILES_PREFIX = "RecentFile.";
    protected int m_MinNumParentDirs;

    public RecentFilesWithEncodingHandler(String propsFile, M menu) {
        super(propsFile, menu);
    }

    public RecentFilesWithEncodingHandler(String propsFile, int maxCount, M menu) {
        super(propsFile, maxCount, menu);
    }

    public RecentFilesWithEncodingHandler(String propsFile, String propPrefix, int maxCount, M menu) {
        super(propsFile, propPrefix, maxCount, menu);
    }

    @Override
    protected boolean check(String item) {
        return RecentFilesWithEncodingHandler.getFile(item).exists();
    }

    protected synchronized int determineMinimumNumberOfParentDirs() {
        HashSet<String> files;
        int result = -1;
        ArrayList<File> list = new ArrayList<File>();
        for (String item : this.m_RecentItems) {
            File file = RecentFilesWithEncodingHandler.getFile(item);
            if (list.contains(file)) continue;
            list.add(file);
        }
        int num = 0;
        do {
            files = new HashSet<String>();
            for (int i = 0; i < list.size(); ++i) {
                files.add(FileUtils.createPartialFilename((File)list.get(i), num));
            }
            if (files.size() == list.size()) {
                result = num;
                continue;
            }
            ++num;
        } while (files.size() < list.size());
        return result;
    }

    @Override
    protected String getCountKey() {
        return RECENTFILES_COUNT;
    }

    @Override
    protected String getItemPrefix() {
        return RECENTFILES_PREFIX;
    }

    @Override
    protected String toString(String obj) {
        return obj;
    }

    @Override
    protected String fromString(String s) {
        return s;
    }

    @Override
    protected void preUpdateMenu() {
        super.preUpdateMenu();
        this.m_MinNumParentDirs = this.determineMinimumNumberOfParentDirs();
    }

    @Override
    protected String createMenuItemText(int index, String item) {
        return FileUtils.createPartialFilename(RecentFilesWithEncodingHandler.getFile(item), this.m_MinNumParentDirs);
    }

    public static File getFile(String item) {
        File result;
        if (item.indexOf(9) > -1) {
            String[] parts = item.split("\t");
            result = new File(parts[0]);
        } else {
            result = new File(item);
        }
        return result;
    }

    public static String getEncoding(String item) {
        String result;
        if (item.indexOf(9) > -1) {
            String[] parts = item.split("\t");
            result = parts[1];
        } else {
            result = "UTF-8";
        }
        return result;
    }
}

