/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow;

import adams.core.CleanUpHandler;
import adams.core.Properties;
import adams.flow.core.AbstractActor;
import adams.gui.core.BaseTabbedPane;
import adams.gui.flow.FlowEditorPanel;
import adams.gui.flow.FlowPanel;
import adams.gui.flow.tree.Tree;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.Constructor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;

public class FlowTabbedPane
extends BaseTabbedPane
implements CleanUpHandler {
    private static final long serialVersionUID = -1675887825433207074L;
    protected FlowEditorPanel m_Owner;

    public FlowTabbedPane(FlowEditorPanel owner) {
        this.m_Owner = owner;
        this.setCloseTabsWithMiddelMouseButton(true);
        this.setMiddleMouseButtonCloseApprover(new BaseTabbedPane.MiddleMouseButtonCloseApprover(){

            @Override
            public boolean approveClosingWithMiddleMouseButton(BaseTabbedPane source) {
                boolean result = FlowTabbedPane.this.checkForModified();
                FlowPanel panel = FlowTabbedPane.this.getCurrentPanel();
                if (result && panel.isModified()) {
                    panel.setModified(false);
                }
                return result;
            }
        });
        this.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FlowTabbedPane.this.tabSelected(e);
            }
        });
    }

    public FlowEditorPanel getOwner() {
        return this.m_Owner;
    }

    public FlowPanel newPanel() {
        FlowPanel result;
        Properties props = FlowEditorPanel.getProperties();
        String clsname = props.getProperty("FlowPanelClass", FlowPanel.class.getName());
        try {
            Class<?> cls = Class.forName(clsname);
            Constructor<?> constr = cls.getConstructor(FlowTabbedPane.class);
            result = (FlowPanel)constr.newInstance(this);
        }
        catch (Exception e) {
            System.err.println("Failed to instantiate flow panel class: " + clsname);
            e.printStackTrace();
            result = new FlowPanel(this);
        }
        this.addTab(result.getTitle(), result);
        this.setSelectedComponent(result);
        return result;
    }

    public int getPanelCount() {
        return this.getTabCount();
    }

    public FlowPanel getPanelAt(int index) {
        return (FlowPanel)this.getComponentAt(index);
    }

    public boolean hasCurrentPanel() {
        return this.getCurrentPanel() != null;
    }

    public FlowPanel getCurrentPanel() {
        if (this.getSelectedIndex() != -1) {
            return (FlowPanel)this.getComponentAt(this.getSelectedIndex());
        }
        return null;
    }

    public Tree getTreeAt(int index) {
        return this.getPanelAt(index).getTree();
    }

    public boolean hasCurrentTree() {
        return this.getCurrentTree() != null;
    }

    public Tree getCurrentTree() {
        if (this.getSelectedIndex() != -1) {
            return this.getPanelAt(this.getSelectedIndex()).getTree();
        }
        return null;
    }

    @Override
    public void cleanUp() {
        for (int i = 0; i < this.getPanelCount(); ++i) {
            this.getPanelAt(i).cleanUp();
        }
    }

    protected boolean checkForModified() {
        if (this.m_Owner == null) {
            return true;
        }
        return this.m_Owner.checkForModified();
    }

    @Override
    protected void afterTabClosedWithMiddleMouseButton(int index, Component comp) {
        if (((FlowPanel)comp).isRunning()) {
            ((FlowPanel)comp).stop(true);
        } else {
            ((FlowPanel)comp).cleanUp();
        }
        this.updateOwnerTitle();
    }

    protected void tabSelected(ChangeEvent e) {
        if (this.getPanelCount() == 0) {
            this.m_Owner.getTabs().notifyTabs(new TreePath[0], new AbstractActor[0]);
        } else {
            this.m_Owner.getTabs().notifyTabs(this.m_Owner.getCurrentPanel().getTree().getSelectionPaths(), this.m_Owner.getCurrentPanel().getTree().getSelectedActors());
        }
        this.updateOwnerTitle();
        if (this.hasCurrentPanel() && this.getCurrentPanel().isRunning()) {
            this.getOwner().showStatus("Running");
        } else {
            this.getOwner().showStatus("");
        }
        this.updateCurrentDirectory();
        this.m_Owner.update();
    }

    protected void updateOwnerTitle() {
        if (this.m_Owner == null) {
            return;
        }
        if (this.getPanelCount() == 0) {
            String title = "Flow editor";
            this.m_Owner.setParentTitle(title);
        } else {
            this.getCurrentPanel().updateTitle();
        }
    }

    public void updateCurrentDirectory() {
        if (!this.hasCurrentPanel()) {
            return;
        }
        File file = this.getCurrentPanel().getCurrentFile();
        if (file == null) {
            return;
        }
        this.getOwner().setCurrentDirectory(file.getParentFile());
    }

    @Override
    public void removeTabAt(int index) {
        if (index < 0) {
            return;
        }
        if (!this.checkForModified()) {
            return;
        }
        FlowPanel panel = this.getPanelAt(index);
        panel.cleanUp();
        super.removeTabAt(index);
        this.updateOwnerTitle();
    }
}

