/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.postprocessor;

import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.flow.control.StorageName;
import adams.flow.core.AbstractActor;
import adams.flow.processor.UpdateStorageName;
import adams.gui.event.ActorChangeEvent;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.Tree;
import adams.gui.flow.tree.postprocessor.AbstractEditPostProcessor;
import java.util.List;

public class StorageValueRenamed
extends AbstractEditPostProcessor {
    private static final long serialVersionUID = -8661419635908219055L;

    public String globalInfo() {
        return "Updates all references of the storage value that was renamed.";
    }

    protected StorageName getStorageName(AbstractActor actor) {
        StorageName result = null;
        List<AbstractOption> options = actor.getOptionManager().getOptionsList();
        for (int i = 0; i < options.size(); ++i) {
            AbstractArgumentOption option;
            if (!(options.get(i) instanceof AbstractArgumentOption) || (option = (AbstractArgumentOption)options.get(i)).isMultiple() || !option.getBaseClass().equals(StorageName.class)) continue;
            result = (StorageName)option.getCurrentValue();
            break;
        }
        return result;
    }

    @Override
    public boolean applies(AbstractActor parent, AbstractActor oldActor, AbstractActor newActor) {
        boolean result = false;
        StorageName oldName = this.getStorageName(oldActor);
        StorageName newName = this.getStorageName(newActor);
        if (oldName != null) {
            result = !oldName.equals(newName);
        }
        return result;
    }

    @Override
    public boolean postProcess(Tree tree, AbstractActor parent, AbstractActor oldActor, AbstractActor newActor) {
        boolean result = false;
        UpdateStorageName updater = new UpdateStorageName();
        updater.setOldName(this.getStorageName(oldActor).getValue());
        updater.setNewName(this.getStorageName(newActor).getValue());
        updater.process(tree.getActor());
        if (updater.isModified()) {
            result = true;
            tree.setModified(true);
            tree.setActor(updater.getModifiedActor());
            tree.notifyActorChangeListeners(new ActorChangeEvent(tree, new Node[0], ActorChangeEvent.Type.MODIFY_BULK));
            tree.refreshTabs();
        }
        return result;
    }
}

