/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.core.base.BaseBoolean;
import adams.core.option.AbstractOption;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.MultiLineValueDialog;
import adams.gui.goe.MultiSelectionEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BaseBooleanEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler,
MultiSelectionEditor {
    protected JComboBox m_TextValue;

    public static String toString(AbstractOption option, Object object) {
        return ((BaseBoolean)object).getValue();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new BaseBoolean(str);
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return BaseBooleanEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        return new BaseBoolean(str);
    }

    @Override
    public String getJavaInitializationString() {
        String result = "new " + BaseBoolean.class.getName() + "(\"" + Utils.backQuoteChars(this.getValue().toString()) + "\")";
        return result;
    }

    protected String getStringToPaint() {
        return "" + this.getValue();
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = this.getStringToPaint();
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    protected BaseBoolean parse(String s) {
        BaseBoolean result;
        try {
            result = new BaseBoolean(s);
            result.setValue(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    @Override
    protected JComponent createCustomEditor() {
        JPanel panelAll = new JPanel(new BorderLayout());
        JPanel panel = new JPanel(new FlowLayout(0));
        panelAll.add((Component)panel, "Center");
        this.m_TextValue = new JComboBox<String>(new String[]{"false", "true"});
        this.m_TextValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    BaseBooleanEditor.this.acceptInput();
                } else if (e.getKeyCode() == 27) {
                    e.consume();
                    BaseBooleanEditor.this.discardInput();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        JLabel label = new JLabel("Boolean value");
        label.setDisplayedMnemonic('v');
        label.setLabelFor(this.m_TextValue);
        panel.add(label);
        panel.add(this.m_TextValue);
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseBooleanEditor.this.acceptInput();
            }
        });
        panelButtons.add(buttonOK);
        JButton buttonClose = new JButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseBooleanEditor.this.discardInput();
            }
        });
        panelButtons.add(buttonClose);
        return panelAll;
    }

    protected boolean isValid(String s) {
        return ((BaseBoolean)this.getValue()).isValid(s);
    }

    protected boolean isUnchanged(String s) {
        return s.equals(((BaseBoolean)this.getValue()).getValue());
    }

    protected void acceptInput() {
        String s = this.m_TextValue.getSelectedItem().toString();
        if (this.isValid(s) && !this.isUnchanged(s)) {
            this.setValue(this.parse(s));
        }
        this.closeDialog(1);
    }

    protected void discardInput() {
        this.closeDialog(0);
    }

    @Override
    protected void initForDisplay() {
        super.initForDisplay();
        if (!this.m_TextValue.getSelectedItem().toString().equals("" + this.getValue())) {
            this.m_TextValue.setSelectedItem("" + this.getValue());
        }
        this.m_TextValue.setToolTipText(((BaseBoolean)this.getValue()).getTipText());
        this.m_TextValue.grabFocus();
    }

    @Override
    public Object[] getSelectedObjects(Container parent) {
        Object[] result;
        MultiLineValueDialog dialog = new MultiLineValueDialog();
        dialog.setInfoText("Enter the string representations ('true'/'t' or 'false'/'f'), one per line:");
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        if (dialog.getOption() == 0) {
            Vector<String> lines = new Vector<String>(Arrays.asList(dialog.getContent().split("\n")));
            Utils.removeEmptyLines(lines);
            result = (Object[])Array.newInstance(BaseBoolean.class, lines.size());
            for (int i = 0; i < lines.size(); ++i) {
                Array.set(result, i, this.parse(lines.get(i)));
            }
        } else {
            result = (Object[])Array.newInstance(BaseBoolean.class, 0);
        }
        return result;
    }
}

