/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.io.FlowFile;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOption;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.PreviewBrowserDialog;
import adams.gui.flow.FlowEditorDialog;
import adams.gui.flow.FlowFileChooser;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.InlineEditorSupport;
import adams.gui.goe.PropertyPanel;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class FlowFileEditor
extends AbstractPropertyEditorSupport
implements PropertyPanel.PopupMenuCustomizer,
CustomStringRepresentationHandler,
InlineEditorSupport {
    protected transient FlowFileChooser m_FileChooser;

    public static String toString(AbstractOption option, Object object) {
        return ((FlowFile)object).getPath();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new FlowFile(str);
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return FlowFileEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        return FlowFileEditor.valueOf(null, str);
    }

    @Override
    public String getJavaInitializationString() {
        FlowFile f = (FlowFile)this.getValue();
        if (f == null) {
            return "null";
        }
        return "new FlowFile(\"" + f.getName() + "\")";
    }

    protected FlowFileChooser getFileChooser() {
        if (this.m_FileChooser == null) {
            FlowFile currentFile = (FlowFile)this.getValue();
            FlowFileChooser fileChooser = new FlowFileChooser();
            if (currentFile == null) {
                fileChooser.setCurrentDirectory(new FlowFile(System.getProperty("user.dir")));
            }
            fileChooser.setApproveButtonText("Select");
            fileChooser.setApproveButtonMnemonic('S');
            fileChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String cmdString = e.getActionCommand();
                    if (cmdString.equals("ApproveSelection")) {
                        FlowFile newVal = new FlowFile(FlowFileEditor.this.getFileChooser().getSelectedFile());
                        FlowFileEditor.this.setValue(newVal);
                        FlowFileEditor.this.closeDialog(1);
                    } else {
                        FlowFileEditor.this.closeDialog(0);
                    }
                }
            });
            this.m_FileChooser = fileChooser;
        }
        return this.m_FileChooser;
    }

    @Override
    protected JComponent createCustomEditor() {
        return this.getFileChooser();
    }

    @Override
    protected void initForDisplay() {
        super.initForDisplay();
        FlowFile currentFile = (FlowFile)this.getValue();
        if (currentFile != null) {
            this.getFileChooser().setSelectedFile(currentFile);
        }
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        FlowFile f = (FlowFile)this.getValue();
        String val = "No file";
        if (f != null) {
            val = f.getPath();
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    @Override
    public boolean isInlineEditingAvailable() {
        return true;
    }

    @Override
    public void setInlineValue(String value) {
        if (this.isInlineValueValid(value)) {
            this.setValue(new FlowFile(value));
        }
    }

    @Override
    public String getInlineValue() {
        return ((FlowFile)this.getValue()).toString();
    }

    @Override
    public boolean isInlineValueValid(String value) {
        return PlaceholderFile.isValid(value);
    }

    @Override
    public void customizePopupMenu(final BasePanel owner, JPopupMenu menu) {
        final FlowFile file = (FlowFile)this.getValue();
        JMenuItem menuitem = new JMenuItem("Open in Flow editor...");
        menuitem.setIcon(GUIHelper.getIcon("flow.gif"));
        menuitem.setEnabled(file.exists() && !file.isDirectory());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorDialog dialog = owner.getParentDialog() != null ? new FlowEditorDialog(owner.getParentDialog()) : new FlowEditorDialog(owner.getParentFrame());
                dialog.getFlowEditorPanel().loadUnsafe(file);
                dialog.setLocationRelativeTo(dialog.getOwner());
                dialog.setVisible(true);
                if (dialog.getFlowEditorPanel().getCurrentFile() != null) {
                    FlowFileEditor.this.setValue(new FlowFile(dialog.getFlowEditorPanel().getCurrentFile()));
                }
            }
        });
        menu.addSeparator();
        menu.add(menuitem);
        menuitem = new JMenuItem("Open in preview browser...");
        menuitem.setIcon(GUIHelper.getIcon("open.gif"));
        menuitem.setEnabled(file.exists() && !file.isDirectory());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewBrowserDialog dialog = new PreviewBrowserDialog();
                dialog.open(file);
                dialog.setLocationRelativeTo(dialog.getOwner());
                dialog.setVisible(true);
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem("Copy (absolute path)");
        menuitem.setIcon(GUIHelper.getIcon("copy.gif"));
        menuitem.setEnabled(true);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIHelper.copyToClipboard(file.getAbsolutePath());
            }
        });
        menu.add(menuitem);
    }
}

