/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.data.container.DataContainer;
import adams.gui.scripting.AbstractDataContainerPanelScriptlet;
import adams.gui.scripting.AbstractDataContainerUpdatingPostProcessor;
import adams.gui.visualization.container.AbstractContainerManager;
import adams.gui.visualization.container.VisibilityContainer;
import adams.gui.visualization.container.VisibilityContainerManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractDataContainerUpdatingScriptlet
extends AbstractDataContainerPanelScriptlet {
    private static final long serialVersionUID = -623707457032656271L;
    protected AbstractDataContainerUpdatingPostProcessor m_PostProcessor;

    @Override
    protected void initialize() {
        super.initialize();
        if (this.hasOwner()) {
            this.m_PostProcessor = this.getOwner().getDataContainerUpdatingPostProcessor();
        }
    }

    protected void updateDataContainers(List<DataContainer> conts, boolean overlay) {
        this.updateDataContainers(conts, overlay, new HashSet<Integer>());
    }

    protected void updateDataContainers(List<? extends DataContainer> conts, boolean overlay, HashSet<Integer> exclude) {
        int i;
        Object manager = this.getDataContainerPanel().getContainerManager();
        boolean[] visible = new boolean[((AbstractContainerManager)manager).count()];
        for (i = 0; i < visible.length; ++i) {
            visible[i] = ((VisibilityContainerManager)manager).isVisible(i);
        }
        ArrayList data = new ArrayList();
        int n = 0;
        for (i = 0; i < visible.length; ++i) {
            if (!visible[i]) {
                data.add(((AbstractContainerManager)manager).get(i));
                ((VisibilityContainer)data.get(data.size() - 1)).setVisible(false);
                continue;
            }
            if (overlay) {
                data.add(((AbstractContainerManager)manager).get(i));
                ((VisibilityContainer)data.get(data.size() - 1)).setVisible(true);
            }
            ++n;
        }
        n = 0;
        for (i = 0; i < visible.length; ++i) {
            if (!visible[i] || exclude.contains(i)) continue;
            data.add(((AbstractContainerManager)manager).newContainer(conts.get(n)));
            ++n;
        }
        ((AbstractContainerManager)manager).startUpdate();
        ((AbstractContainerManager)manager).clear();
        ((AbstractContainerManager)manager).addAll(data);
        ((AbstractContainerManager)manager).finishUpdate();
        if (this.m_PostProcessor != null) {
            this.m_PostProcessor.postProcess(conts);
        }
    }
}

