/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.Properties;
import adams.gui.tools.AbstractManagementPanel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public abstract class AbstractManagementPanelWithProperties<T extends Comparable>
extends AbstractManagementPanel<T> {
    private static final long serialVersionUID = 153385171161348941L;
    protected Properties m_Properties;

    protected abstract Properties getProperties();

    protected abstract boolean storeProperties();

    protected abstract String createKey(T var1);

    protected abstract T fromString(String var1);

    protected abstract String toString(T var1);

    @Override
    protected List<T> loadAll() {
        ArrayList<T> result = new ArrayList<T>();
        Enumeration<?> enm = this.getProperties().propertyNames();
        while (enm.hasMoreElements()) {
            String key = enm.nextElement().toString();
            T value = this.fromString(this.getProperties().getProperty(key));
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    @Override
    protected boolean exists(T value) {
        String key = this.createKey(value);
        if (key == null) {
            return false;
        }
        return this.getProperties().containsKey(key);
    }

    @Override
    protected boolean store(T value) {
        String key = this.createKey(value);
        this.getProperties().setProperty(key, this.toString(value));
        return this.storeProperties();
    }

    @Override
    protected boolean remove(T value) {
        this.getProperties().remove(this.createKey(value));
        return true;
    }
}

