/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.gui.core.TextEditorPanel;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import java.io.File;

public class HexaDecimalHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = 6961566580558582551L;

    @Override
    public String globalInfo() {
        return "Displays any file in hexadecimal notation";
    }

    @Override
    public String[] getExtensions() {
        return new String[]{"*"};
    }

    @Override
    protected PreviewPanel createPreview(File file) {
        byte[] binary = FileUtils.loadByteArrayFromFile(file);
        int width = ("" + binary.length).length();
        StringBuilder hex = new StringBuilder(binary.length * 5);
        StringBuilder human = new StringBuilder();
        for (int i = 0; i < binary.length; ++i) {
            if (i % 16 == 0) {
                if (i > 0) {
                    hex.append(" | ");
                    hex.append(human.toString());
                    hex.append("\n");
                    human.delete(0, human.length());
                }
                hex.append(Utils.padLeft("" + (i + 1), '0', width));
                hex.append("-");
                hex.append(Utils.padLeft("" + (i + 16), '0', width));
                hex.append(" |");
            }
            hex.append(" ");
            hex.append(Utils.toHex(binary[i]));
            if (binary[i] > 31) {
                human.append((char)binary[i]);
                continue;
            }
            human.append(".");
        }
        TextEditorPanel panel = new TextEditorPanel();
        panel.setEditable(false);
        panel.setContent(hex.toString());
        return new PreviewPanel(panel, panel.getTextArea());
    }
}

