/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core.axis;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.gui.visualization.core.axis.AbstractLimitedTickGenerator;
import adams.gui.visualization.core.axis.Direction;
import adams.gui.visualization.core.axis.Tick;

@MixedCopyright(copyright="2007-2013 IOLA and Ole Laursen", license=License.MIT, url="https://github.com/flot/flot/blob/master/jquery.flot.js", note="Original code was in JavaScript")
public class FancyTickGenerator
extends AbstractLimitedTickGenerator {
    private static final long serialVersionUID = -3950212023344727427L;

    @Override
    public String globalInfo() {
        return "A fancy tick generator based on code from the http://www.flotcharts.org/ project.\nIt attempts to generate ticks at nice human-readable locations, e.g., '10, 20, 30, 40, 50'.";
    }

    protected double floorInBase(double n, double base) {
        return base * Math.floor(n / base);
    }

    @Override
    protected void doGenerate() {
        double prev;
        double size;
        double dec;
        double magn;
        int noTicks = this.m_NumTicks > 0 ? this.m_NumTicks : (int)(0.3 * Math.sqrt(this.m_Parent.getParent().getDirection() == Direction.VERTICAL ? (double)this.m_Parent.getParent().getHeight() : (double)this.m_Parent.getParent().getWidth()));
        double delta = (this.m_Parent.getActualMaximum() - this.m_Parent.getActualMinimum()) / (double)noTicks;
        double norm = delta / (magn = Math.pow(10.0, -(dec = -Math.floor(Math.log(delta) / Math.log(10.0)))));
        if (norm < 1.5) {
            size = 1.0;
        } else if (norm < 3.0) {
            size = 2.0;
            if (norm > 2.25) {
                size = 2.5;
                dec += 1.0;
            }
        } else {
            size = norm < 7.5 ? 5.0 : 10.0;
        }
        double tickSize = size *= magn;
        double start = this.floorInBase(this.m_Parent.getActualMinimum(), tickSize);
        int i = 0;
        double v = Double.NaN;
        do {
            prev = v;
            v = start + (double)i * tickSize;
            String label = this.fixLabel(this.m_Parent.valueToDisplay(v));
            this.m_Ticks.add(new Tick(this.m_Parent.valueToPos(v), label));
            ++i;
            this.addLabel(label);
        } while (v < this.m_Parent.getActualMaximum() && v != prev);
    }
}

