/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core.axis;

import adams.gui.visualization.core.axis.AbstractLimitedTickGenerator;
import adams.gui.visualization.core.axis.Tick;

public class SimpleTickGenerator
extends AbstractLimitedTickGenerator {
    private static final long serialVersionUID = -3950212023344727427L;

    @Override
    public String globalInfo() {
        return "A simple tick generator, which places the ticks always at the same position.";
    }

    @Override
    protected void doGenerate() {
        double incValue = (this.m_Parent.getActualMaximum() - this.m_Parent.getActualMinimum()) / (double)this.m_NumTicks;
        if (Double.isNaN(incValue)) {
            return;
        }
        for (int i = 0; i < this.m_NumTicks + 1; ++i) {
            double value = this.m_Parent.getActualMinimum() + (double)i * incValue;
            int pos = this.m_Parent.valueToPos(value);
            String label = this.fixLabel(this.m_Parent.valueToDisplay(this.m_Parent.posToValue(pos)));
            this.m_Ticks.add(new Tick(pos, label));
            this.addLabel(label);
        }
    }
}

