/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingLevel;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AbstractStrokePaintlet;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.plot.HitDetectorSupporter;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequencePaintletWithCustomerContainerManager;
import adams.gui.visualization.sequence.XYSequencePanel;
import java.awt.Color;
import java.util.logging.Level;

public abstract class AbstractXYSequencePaintlet
extends AbstractStrokePaintlet
implements XYSequencePaintletWithCustomerContainerManager,
HitDetectorSupporter<AbstractXYSequencePointHitDetector> {
    private static final long serialVersionUID = 1570802737796372715L;
    protected AbstractXYSequencePointHitDetector m_HitDetector;
    protected XYSequenceContainerManager m_CustomerContainerManager;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_HitDetector = this.newHitDetector();
        this.m_CustomerContainerManager = null;
    }

    @Override
    public void memberChanged() {
        super.memberChanged();
        if (this.m_HitDetector != null) {
            this.updateHitDetector();
        }
    }

    protected void updateHitDetector() {
    }

    @Override
    public abstract AbstractXYSequencePointHitDetector newHitDetector();

    @Override
    public void setLoggingLevel(LoggingLevel value) {
        super.setLoggingLevel(value);
        if (this.m_HitDetector != null) {
            this.m_HitDetector.setDebug(LoggingHelper.isAtLeast(value.getLevel(), Level.INFO));
        }
    }

    @Override
    public void setPanel(PaintablePanel value) {
        super.setPanel(value);
        this.m_HitDetector.setOwner(this.getSequencePanel());
    }

    @Override
    public XYSequencePanel getSequencePanel() {
        return (XYSequencePanel)this.m_Panel;
    }

    @Override
    public void setCustomContainerManager(XYSequenceContainerManager value) {
        this.m_CustomerContainerManager = value;
    }

    @Override
    public XYSequenceContainerManager getCustomerContainerManager() {
        return this.m_CustomerContainerManager;
    }

    @Override
    public XYSequenceContainerManager getActualContainerManager() {
        if (this.m_CustomerContainerManager != null) {
            return this.m_CustomerContainerManager;
        }
        return (XYSequenceContainerManager)this.getSequencePanel().getContainerManager();
    }

    @Override
    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.PAINT;
    }

    public Color getColor(int index) {
        return ((XYSequenceContainer)this.getActualContainerManager().get(index)).getColor();
    }

    @Override
    public AbstractXYSequencePointHitDetector getHitDetector() {
        return this.m_HitDetector;
    }
}

