/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.statistics;

import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.data.sequence.XYSequencePointComparator;
import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.ArrayHistogram;
import adams.data.statistics.StatUtils;
import adams.flow.sink.sequenceplotter.SequencePlotterPanel;
import adams.gui.core.BaseDialog;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTabbedPane;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequenceStickPaintlet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;

public class HistogramFactory {
    public static final int NUM_BINS = 50;
    public static final boolean USE_BARPLOT = false;

    public static Panel getPanel() {
        return new Panel();
    }

    public static SetupDialog getSetupDialog(java.awt.Dialog owner, Dialog.ModalityType modality) {
        return new SetupDialog(owner, modality);
    }

    public static SetupDialog getSetupDialog(Frame owner, boolean modal) {
        return new SetupDialog(owner, modal);
    }

    public static Dialog getDialog(java.awt.Dialog owner, Dialog.ModalityType modality) {
        return new Dialog(owner, modality);
    }

    public static Dialog getDialog(Frame owner, boolean modal) {
        return new Dialog(owner, modal);
    }

    public static class Dialog
    extends BaseDialog {
        private static final long serialVersionUID = 2464157048335973279L;
        protected BaseTabbedPane m_TabbedPane;

        public Dialog(java.awt.Dialog owner, Dialog.ModalityType modality) {
            super(owner, modality);
        }

        public Dialog(Frame owner, boolean modal) {
            super(owner, modal);
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.setTitle("Histogram");
            this.getContentPane().setLayout(new BorderLayout());
            this.m_TabbedPane = new BaseTabbedPane();
            this.getContentPane().add((Component)this.m_TabbedPane, "Center");
            this.setSize(new Dimension(800, 600));
        }

        public void clear() {
            this.m_TabbedPane.removeAll();
        }

        public void add(ArrayHistogram hist, double[] data, String name) {
            this.add(hist, StatUtils.toNumberArray(data), name);
        }

        public void add(ArrayHistogram hist, Number[] data, String name) {
            Panel panel = new Panel();
            panel.add(hist, data, name);
            this.m_TabbedPane.addTab(name, panel);
        }
    }

    public static class SetupDialog
    extends GenericObjectEditorDialog {
        private static final long serialVersionUID = 4215632076348292959L;

        public SetupDialog(java.awt.Dialog owner, Dialog.ModalityType modality) {
            super(owner, modality);
        }

        public SetupDialog(Frame owner, boolean modal) {
            super(owner, modal);
        }

        @Override
        protected void initialize() {
            super.initialize();
            this.getGOEEditor().setClassType(AbstractArrayStatistic.class);
            this.getGOEEditor().setCanChangeClassInDialog(false);
            this.setCurrent(new ArrayHistogram());
        }
    }

    public static class Panel
    extends BasePanel {
        private static final long serialVersionUID = -1990327944906647098L;
        protected SequencePlotterPanel m_PlotPanel;

        @Override
        protected void initGUI() {
            super.initGUI();
            this.setLayout(new BorderLayout());
            this.m_PlotPanel = new SequencePlotterPanel("Histogram");
            this.m_PlotPanel.setPaintlet(new XYSequenceStickPaintlet());
            this.add((Component)this.m_PlotPanel, "Center");
        }

        public void add(ArrayHistogram hist, double[] data, String name) {
            this.add(hist, StatUtils.toNumberArray(data), name);
        }

        public void add(ArrayHistogram hist, Number[] data, String name) {
            ArrayHistogram histogram = (ArrayHistogram)hist.shallowCopy(true);
            histogram.add(data);
            AbstractArrayStatistic.StatisticContainer cont = histogram.calculate();
            int numBins = (Integer)cont.getMetaData("num-bins");
            XYSequenceContainerManager manager = (XYSequenceContainerManager)this.m_PlotPanel.getContainerManager();
            manager.startUpdate();
            XYSequence seq = new XYSequence();
            seq.setID(manager.count() + 1 + ": " + numBins + " bins");
            seq.setComparison(XYSequencePointComparator.Comparison.X);
            for (int i = 0; i < numBins; ++i) {
                seq.add(new XYSequencePoint(i, (double)((Double)cont.getCell(0, i))));
            }
            XYSequenceContainer seqcont = manager.newContainer(seq);
            manager.add(seqcont);
            manager.finishUpdate();
            histogram.destroy();
        }
    }
}

