/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.core.io.PlaceholderFile;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.parser.AbstractSymbolEvaluator;
import adams.parser.spreadsheetformula.Parser;
import adams.parser.spreadsheetformula.Scanner;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java_cup.runtime.DefaultSymbolFactory;
import java_cup.runtime.SymbolFactory;

public class SpreadSheetFormula
extends AbstractSymbolEvaluator<Object> {
    private static final long serialVersionUID = 8014316012335802585L;
    protected SpreadSheet m_Sheet;
    protected SpreadSheetReader m_Reader;
    protected PlaceholderFile m_Input;

    @Override
    public String globalInfo() {
        return "Evaluates mathematical expressions.\n\nThe following grammar is used:\n\n" + this.getGrammar();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", new CsvSpreadSheetReader());
        this.m_OptionManager.add("input", "input", new PlaceholderFile("."));
    }

    @Override
    public String getGrammar() {
        return "expr_list ::= '=' expr_list expr_part | expr_part ;\nexpr_part ::=  expr ;\n\nexpr      ::=   ( expr )\n\n# data types\n              | number\n              | string\n              | boolean\n              | date\n              | cell\n\n# constants\n              | true\n              | false\n              | pi\n              | e\n              | now()\n              | today()\n\n# negating numeric value\n              | -expr\n\n# comparisons\n              | expr < expr\n              | expr <= expr\n              | expr > expr\n              | expr >= expr\n              | expr = expr\n              | expr != expr (or: expr <> expr)\n\n# boolean operations\n              | ! expr (or: not expr)\n              | expr & expr (or: expr and expr)\n              | expr | expr (or: expr or expr)\n              | if[else] ( expr , expr (if true) , expr (if false) )\n\n# arithmetics\n              | expr + expr\n              | expr - expr\n              | expr * expr\n              | expr / expr\n              | expr ^ expr (power of)\n              | expr % expr (modulo)\n              ;\n\n# numeric functions\n              | abs ( expr | cell )\n              | sqrt ( expr | cell )\n              | log ( expr | cell )\n              | exp ( expr | cell )\n              | sin ( expr | cell )\n              | cos ( expr | cell )\n              | tan ( expr | cell )\n              | rint ( expr | cell )\n              | floor ( expr | cell )\n              | pow[er] ( expr | cell , expr | cell )\n              | ceil ( expr | cell )\n              | sum ( cell1 : cell2 )\n              | min ( cell1 : cell2 )\n              | max ( cell1 : cell2 )\n              | average ( cell1 : cell2 )\n              | stdev ( cell1 : cell2 )\n              | stdevp ( cell1 : cell2 )\n              | countif ( cell1 : cell2 ; expr )\n              | sumif ( cell1 : cell2 ; expr )\n              | sumif ( cell1 : cell2 ; expr : sumCell1 : sumCell2 )\n              | year ( expr | cell )\n              | month ( expr | cell )\n              | day ( expr | cell )\n              | hour ( expr | cell )\n              | minute ( expr | cell )\n              | second ( expr | cell )\n              | weekday ( expr | cell )\n              | weeknum ( expr | cell )\n\n# string functions\n              | substr ( expr , start [, end] )\n              | left ( expr , len )\n              | mid ( expr , start , len )\n              | right ( expr , len )\n              | rept ( expr , count )\n              | concatenate ( expr1 , expr2 [, expr3-5] )\n              | lower[case] ( expr )\n              | upper[case] ( expr )\n              | trim ( expr )\n              | matches ( expr , regexp )\n              | trim ( expr )\n              | len[gth] ( str )\n              | find ( search , expr [, pos] )\n              | replace ( str , pos , len , newstr )\n              | substitute ( str , find , replace [, occurrences] )\n              ;\n\nNotes:\n- Cells are denoted by column in letter and row in digit, e.g., 'C12'.\n- 'start' and 'end' for function 'substr' are indices that start at 1.\n- Index 'end' for function 'substr' is excluded (like Java's 'String.substring(int,int)' method)\n- Line comments start with '#'.\n- Semi-colons (';') or commas (',') can be used as separator in the formulas,\n  e.g., 'pow(2,2)' is equivalent to 'pow(2;2)'\n- dates have to be of format 'yyyy-MM-dd' or 'yyyy-MM-dd HH:mm:ss'\n- times have to be of format 'HH:mm:ss' or 'yyyy-MM-dd HH:mm:ss'\n- the characters in square brackets in function names are optional:\n  e.g. 'len(\"abc\")' is the same as 'length(\"abc\")'\n\nA lot of the functions have been modeled after LibreOffice:\n  https://help.libreoffice.org/Calc/Functions_by_Category\n";
    }

    @Override
    protected String getDefaultExpression() {
        return "= 42";
    }

    @Override
    public String expressionTipText() {
        return "The spreadsheet formula to evaluate (must evaluate to a double).";
    }

    public void setReader(SpreadSheetReader value) {
        this.m_Reader = value;
    }

    public SpreadSheetReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The spreadsheet reader for loading the spreadsheet to work on.";
    }

    public void setInput(PlaceholderFile value) {
        this.m_Input = value;
    }

    public PlaceholderFile getInput() {
        return this.m_Input;
    }

    public String inputTipText() {
        return "The input file to load with the specified reader; ignored if pointing to directory.";
    }

    public void setSheet(SpreadSheet value) {
        this.m_Sheet = value;
    }

    public SpreadSheet getSheet() {
        return this.m_Sheet;
    }

    @Override
    protected Object initializeSymbol(String name, String value) {
        Double result;
        try {
            result = new Double(value);
        }
        catch (Exception e) {
            result = null;
            this.getLogger().log(Level.SEVERE, "Failed to parse the value of symbol '" + name + "': " + value, e);
        }
        return result;
    }

    @Override
    protected Object doEvaluate(HashMap symbols) throws Exception {
        return SpreadSheetFormula.evaluate(this.m_Expression, symbols, this.m_Sheet);
    }

    protected void loadSheet() {
        if (this.m_Input.exists() && !this.m_Input.isDirectory()) {
            this.m_Sheet = this.m_Reader.read(this.m_Input);
        }
    }

    @Override
    public Object evaluate() throws Exception {
        this.loadSheet();
        return super.evaluate();
    }

    public static Object evaluate(String expr, HashMap symbols, SpreadSheet sheet) throws Exception {
        if ((expr = expr.trim()).startsWith("=")) {
            expr = expr.substring(1);
        }
        DefaultSymbolFactory sf = new DefaultSymbolFactory();
        ByteArrayInputStream parserInput = new ByteArrayInputStream(expr.getBytes());
        Parser parser = new Parser(new Scanner(parserInput, (SymbolFactory)sf), (SymbolFactory)sf);
        parser.setSymbols(symbols);
        parser.setSheet(sheet);
        parser.parse();
        return parser.getResult();
    }

    public static void main(String[] args) {
        SpreadSheetFormula.runEvaluator(SpreadSheetFormula.class, args);
    }
}

