/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaModelContainer;
import adams.flow.core.AbstractActor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.Token;
import adams.flow.source.MOAClustererSetup;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import moa.clusterers.Clusterer;
import weka.core.Instance;
import weka.core.Instances;

public class MOATrainClusterer
extends AbstractTransformer {
    private static final long serialVersionUID = -6015760924658904729L;
    public static final String BACKUP_CLUSTERER = "clusterer";
    protected CallableActorReference m_Clusterer;
    protected Clusterer m_ActualClusterer;
    protected int m_OutputInterval;
    protected int m_Count;

    public String globalInfo() {
        return "Trains a MOA clusterer based on the incoming data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add(BACKUP_CLUSTERER, BACKUP_CLUSTERER, (Object)new CallableActorReference(MOAClustererSetup.class.getSimpleName()));
        this.m_OptionManager.add("output-interval", "outputInterval", (Object)1000, (Number)1, null);
    }

    protected void reset() {
        super.reset();
        this.m_ActualClusterer = null;
        this.m_Count = 0;
    }

    public void setClusterer(CallableActorReference value) {
        this.m_Clusterer = value;
        this.reset();
    }

    public CallableActorReference getClusterer() {
        return this.m_Clusterer;
    }

    public String clustererTipText() {
        return "The callable MOA clusterer to train on the input data and outputs the built clusterer alongside the training header (in a model container).";
    }

    public void setOutputInterval(int value) {
        this.m_OutputInterval = value;
        this.reset();
    }

    public int getOutputInterval() {
        return this.m_OutputInterval;
    }

    public String outputIntervalTipText() {
        return "The number of tokens to wait before forwarding the trained clusterer.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)BACKUP_CLUSTERER, (Object)this.m_Clusterer);
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputInterval", (Object)(this.m_OutputInterval == 1 ? "always" : Integer.valueOf(this.m_OutputInterval)), (String)"/");
        return result;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CLUSTERER);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_ActualClusterer != null) {
            result.put(BACKUP_CLUSTERER, this.m_ActualClusterer);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CLUSTERER)) {
            this.m_ActualClusterer = (Clusterer)state.get(BACKUP_CLUSTERER);
            state.remove(BACKUP_CLUSTERER);
        }
        super.restoreState(state);
    }

    public Class[] accepts() {
        return new Class[]{Instance.class, Instances.class};
    }

    public Class[] generates() {
        return new Class[]{WekaModelContainer.class};
    }

    protected Clusterer getClustererInstance() {
        return (Clusterer)CallableActorHelper.getSetup(Clusterer.class, (CallableActorReference)this.m_Clusterer, (AbstractActor)this);
    }

    protected String doExecute() {
        String result = null;
        try {
            if (this.m_InputToken != null) {
                ArrayList<Instance> data = new ArrayList<Instance>();
                if (this.m_InputToken.getPayload() instanceof Instance) {
                    data.add((Instance)this.m_InputToken.getPayload());
                } else {
                    data.addAll((Collection<Instance>)((Instances)this.m_InputToken.getPayload()));
                }
                if (this.m_ActualClusterer == null) {
                    this.m_ActualClusterer = this.getClustererInstance();
                }
                if (this.m_ActualClusterer == null) {
                    result = "Failed to located clusterer '" + this.m_Clusterer + "'!";
                    return result;
                }
                for (Instance inst : data) {
                    this.m_ActualClusterer.trainOnInstance(inst);
                }
                ++this.m_Count;
                if (this.m_Count % this.m_OutputInterval == 0) {
                    this.m_Count = 0;
                    this.m_OutputToken = new Token((Object)new WekaModelContainer((Object)this.m_ActualClusterer, new Instances(((Instance)data.get(0)).dataset(), 0)));
                }
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to process input: " + this.m_InputToken.getPayload(), e);
        }
        return result;
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_ActualClusterer = null;
    }
}

