/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.lassp.houle.RngPack;

import adams.core.License;
import adams.core.annotation.ThirdPartyCopyright;

@ThirdPartyCopyright(copyright="Paul Houle (paul@honeylocust.com)", license=License.BSD3, url="http://www.honeylocust.com/RngPack/", note="RngPack 1.1a")
public abstract class RandomElement
implements Cloneable {
    Double BMoutput;

    public abstract double raw();

    public void raw(double[] d, int n) {
        for (int i = 0; i < n; ++i) {
            d[i] = this.raw();
        }
    }

    public void raw(double[] d) {
        this.raw(d, d.length);
    }

    public int choose(int hi) {
        return this.choose(1, hi);
    }

    public int choose(int lo, int hi) {
        int value = lo + (int)((double)(hi - lo) * this.raw());
        if (value > hi) {
            value = hi;
        }
        return value;
    }

    public boolean coin() {
        return this.raw() <= 0.5;
    }

    public boolean coin(double p) {
        return this.raw() <= p;
    }

    public double uniform(double lo, double hi) {
        return lo + (hi - lo) * this.raw();
    }

    public double gaussian() {
        double y;
        double x;
        double r;
        if (this.BMoutput != null) {
            double out = this.BMoutput;
            this.BMoutput = null;
            return out;
        }
        while ((r = (x = this.uniform(-1.0, 1.0)) * x + (y = this.uniform(-1.0, 1.0)) * y) >= 1.0) {
        }
        double z = Math.sqrt(-2.0 * Math.log(r) / r);
        this.BMoutput = new Double(x * z);
        return y * z;
    }

    public double gaussian(double sd) {
        return this.gaussian() * sd;
    }

    public double powlaw(double alpha, double cut) {
        return cut * Math.pow(this.raw(), 1.0 / (alpha + 1.0));
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

