/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.sink.AbstractSink;
import adams.gui.core.BrowserHelper;
import java.net.URI;
import java.net.URL;

public class Browser
extends AbstractSink {
    private static final long serialVersionUID = -3490495940421933008L;
    protected PlaceholderFile m_Executable;

    public String globalInfo() {
        return "Displays a URL in a webbrowser.\nBy default, the system's default browser is used. But the user can also specify a custom browser executable.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("executable", "executable", (Object)new PlaceholderFile("."));
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"executable", (Object)(this.m_Executable.isDirectory() ? "<default>" : this.m_Executable));
    }

    public void setExecutable(PlaceholderFile value) {
        this.m_Executable = value;
        this.reset();
    }

    public PlaceholderFile getExecutable() {
        return this.m_Executable;
    }

    public String executableTipText() {
        return "The custom browser executable to use; default browser is used if pointing to a directory.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, URL.class, URI.class};
    }

    protected String doExecute() {
        String result = null;
        if (!this.m_Headless) {
            String url = this.m_InputToken.getPayload() instanceof URL ? ((URL)this.m_InputToken.getPayload()).toString() : (this.m_InputToken.getPayload() instanceof URI ? ((URI)this.m_InputToken.getPayload()).toString() : (String)this.m_InputToken.getPayload());
            result = this.m_Executable.isDirectory() ? BrowserHelper.openURL(null, (String)url, (boolean)false) : BrowserHelper.openURL(null, (String)this.m_Executable.getAbsolutePath(), (String)url, (boolean)false);
        }
        return result;
    }
}

