/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.ellipse;

import georegression.fitting.ellipse.ClosestPointEllipseAngle_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.EllipseRotated_F64;
import java.util.List;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;

public class RefineEllipseEuclideanLeastSquares {
    protected UnconstrainedLeastSquares optimizer;
    double ftol = 1.0E-12;
    double gtol = 1.0E-12;
    int maxIterations = 500;
    ClosestPointEllipseAngle_F64 closestPoint = new ClosestPointEllipseAngle_F64(1.0E-12, 100);
    List<Point2D_F64> points;
    EllipseRotated_F64 found = new EllipseRotated_F64();
    double[] initialParam = new double[0];
    double initialError;

    public RefineEllipseEuclideanLeastSquares(UnconstrainedLeastSquares optimizer) {
        this.optimizer = optimizer;
    }

    public RefineEllipseEuclideanLeastSquares() {
        this(FactoryOptimization.leastSquaresLM((double)0.001, (boolean)true));
    }

    public void setFtol(double ftol) {
        this.ftol = ftol;
    }

    public void setGtol(double gtol) {
        this.gtol = gtol;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public UnconstrainedLeastSquares getOptimizer() {
        return this.optimizer;
    }

    public boolean refine(EllipseRotated_F64 initial, List<Point2D_F64> points) {
        int i;
        this.points = points;
        int numParam = 5 + points.size();
        if (numParam > this.initialParam.length) {
            this.initialParam = new double[numParam];
        }
        this.initialParam[0] = initial.center.x;
        this.initialParam[1] = initial.center.y;
        this.initialParam[2] = initial.a;
        this.initialParam[3] = initial.b;
        this.initialParam[4] = initial.phi;
        this.closestPoint.setEllipse(initial);
        for (i = 0; i < points.size(); ++i) {
            this.closestPoint.process(points.get(i));
            this.initialParam[5 + i] = this.closestPoint.getTheta();
        }
        this.optimizer.setFunction((FunctionNtoM)new Error(), null);
        this.optimizer.initialize(this.initialParam, this.ftol, this.gtol);
        this.initialError = this.optimizer.getFunctionValue();
        for (i = 0; i < this.maxIterations && !this.optimizer.iterate(); ++i) {
        }
        double[] foundParam = this.optimizer.getParameters();
        this.found.center.x = foundParam[0];
        this.found.center.y = foundParam[1];
        this.found.a = foundParam[2];
        this.found.b = foundParam[3];
        this.found.phi = foundParam[4];
        return true;
    }

    public EllipseRotated_F64 getFound() {
        return this.found;
    }

    public double getFitError() {
        return this.optimizer.getFunctionValue();
    }

    protected Error createError() {
        return new Error();
    }

    protected Jacobian createJacobian() {
        return new Jacobian();
    }

    public class Jacobian
    implements FunctionNtoMxN {
        public int getN() {
            return 5 + RefineEllipseEuclideanLeastSquares.this.points.size();
        }

        public int getM() {
            return 2 * RefineEllipseEuclideanLeastSquares.this.points.size();
        }

        public void process(double[] input, double[] output) {
            int i;
            double a = input[2];
            double b = input[3];
            double phi = input[4];
            double cp = Math.cos(phi);
            double sp = Math.sin(phi);
            int M = this.getM();
            int N = this.getN();
            int total = M * N;
            for (i = 0; i < total; ++i) {
                output[i] = 0.0;
            }
            for (i = 0; i < RefineEllipseEuclideanLeastSquares.this.points.size(); ++i) {
                Point2D_F64 p = RefineEllipseEuclideanLeastSquares.this.points.get(i);
                double theta = input[5 + i];
                double ct = Math.cos(theta);
                double st = Math.sin(theta);
                int indexX = 2 * i * N;
                int indexY = indexX + N;
                output[indexX++] = -1.0;
                output[indexY++] = 0.0;
                output[indexX++] = 0.0;
                output[indexY++] = -1.0;
                output[indexX++] = -cp * ct;
                output[indexY++] = -sp * ct;
                output[indexX++] = sp * st;
                output[indexY++] = -cp * st;
                output[indexX++] = a * sp * ct + b * cp * st;
                output[indexY++] = -a * cp * ct + b * sp * st;
                output[indexX + i] = a * cp * st + b * sp * cp;
                output[indexY + i] = a * sp * st - b * cp * cp;
            }
        }
    }

    public class Error
    implements FunctionNtoM {
        public int getN() {
            return 5 + RefineEllipseEuclideanLeastSquares.this.points.size();
        }

        public int getM() {
            return 2 * RefineEllipseEuclideanLeastSquares.this.points.size();
        }

        public void process(double[] input, double[] output) {
            double x0 = input[0];
            double y0 = input[1];
            double a = input[2];
            double b = input[3];
            double phi = input[4];
            double c = Math.cos(phi);
            double s = Math.sin(phi);
            int indexOut = 0;
            for (int i = 0; i < RefineEllipseEuclideanLeastSquares.this.points.size(); ++i) {
                Point2D_F64 p = RefineEllipseEuclideanLeastSquares.this.points.get(i);
                double theta = input[5 + i];
                double x = a * Math.cos(theta);
                double y = b * Math.sin(theta);
                double xx = x0 + c * x - s * y;
                double yy = y0 + s * x + c * y;
                output[indexOut++] = p.x - xx;
                output[indexOut++] = p.y - yy;
            }
        }
    }
}

