/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.se;

import georegression.fitting.MotionTransformPoint;
import georegression.geometry.GeometryMath_F32;
import georegression.geometry.UtilPoint2D_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.se.Se2_F32;
import java.util.List;
import org.ejml.simple.SimpleMatrix;
import org.ejml.simple.SimpleSVD;

public class MotionSe2PointSVD_F32
implements MotionTransformPoint<Se2_F32, Point2D_F32> {
    Se2_F32 motion = new Se2_F32();
    Point2D_F32 meanFrom = new Point2D_F32();
    Point2D_F32 meanTo = new Point2D_F32();

    @Override
    public Se2_F32 getMotion() {
        return this.motion;
    }

    @Override
    public boolean process(List<Point2D_F32> fromPts, List<Point2D_F32> toPts) {
        if (fromPts.size() != toPts.size()) {
            throw new IllegalArgumentException("There must be a 1 to 1 correspondence between the two sets of points");
        }
        UtilPoint2D_F32.mean(fromPts, this.meanFrom);
        UtilPoint2D_F32.mean(toPts, this.meanTo);
        int N = fromPts.size();
        float s11 = 0.0f;
        float s12 = 0.0f;
        float s21 = 0.0f;
        float s22 = 0.0f;
        float m11 = this.meanFrom.x * this.meanTo.x;
        float m12 = this.meanFrom.x * this.meanTo.y;
        float m21 = this.meanFrom.y * this.meanTo.x;
        float m22 = this.meanFrom.y * this.meanTo.y;
        for (int i = 0; i < N; ++i) {
            Point2D_F32 f = fromPts.get(i);
            Point2D_F32 t = toPts.get(i);
            s11 += f.x * t.x;
            s12 += f.x * t.y;
            s21 += f.y * t.x;
            s22 += f.y * t.y;
        }
        s11 = s11 / (float)N - m11;
        s12 = s12 / (float)N - m12;
        s21 = s21 / (float)N - m21;
        s22 = s22 / (float)N - m22;
        SimpleMatrix Sigma = new SimpleMatrix(2, 2, true, new double[]{s11, s12, s21, s22});
        SimpleSVD evd = Sigma.svd(false);
        SimpleMatrix U = evd.getU();
        SimpleMatrix V = evd.getV();
        SimpleMatrix R = (SimpleMatrix)V.mult(U.transpose());
        if (R.determinant() < 0.0) {
            for (int i = 0; i < 2; ++i) {
                V.set(i, 1, -V.get(i, 1));
            }
            R = (SimpleMatrix)V.mult(U.transpose());
            float det = (float)R.determinant();
            if (det < 0.0f) {
                System.out.println("Crap");
            }
        }
        float yaw = (float)Math.atan2(R.get(1, 0), R.get(0, 0));
        GeometryMath_F32.rotate(yaw, this.meanFrom, this.meanFrom);
        this.motion.getTranslation().x = this.meanTo.x - this.meanFrom.x;
        this.motion.getTranslation().y = this.meanTo.y - this.meanFrom.y;
        this.motion.setYaw(yaw);
        return true;
    }

    @Override
    public int getMinimumPoints() {
        return 3;
    }
}

