/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.plane.PlaneGeneral3D_F64;
import georegression.struct.plane.PlaneNormal3D_F64;
import georegression.struct.plane.PlaneTangent3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;

public class UtilPlane3D_F64 {
    public static PlaneGeneral3D_F64 convert(PlaneNormal3D_F64 input, PlaneGeneral3D_F64 output) {
        if (output == null) {
            output = new PlaneGeneral3D_F64();
        }
        Vector3D_F64 n = input.n;
        Point3D_F64 p = input.p;
        output.A = n.x;
        output.B = n.y;
        output.C = n.z;
        output.D = n.x * p.x + n.y * p.y + n.z * p.z;
        return output;
    }

    public static PlaneNormal3D_F64 convert(PlaneTangent3D_F64 input, PlaneNormal3D_F64 output) {
        if (output == null) {
            output = new PlaneNormal3D_F64();
        }
        output.n.x = input.x;
        output.n.y = input.y;
        output.n.z = input.z;
        output.p.set(input);
        return output;
    }

    public static void hessianNormalForm(PlaneGeneral3D_F64 plane) {
        double n = Math.sqrt(plane.A * plane.A + plane.B * plane.B + plane.C * plane.C);
        plane.A /= n;
        plane.B /= n;
        plane.C /= n;
        plane.D /= n;
    }

    public static double evaluate(PlaneGeneral3D_F64 plane, Point3D_F64 point) {
        return plane.A * point.x + plane.B * point.y + plane.C * point.z - plane.D;
    }

    public static double evaluate(PlaneNormal3D_F64 plane, Point3D_F64 point) {
        double dx = point.x - plane.p.x;
        double dy = point.y - plane.p.y;
        double dz = point.z - plane.p.z;
        return plane.n.x * dx + plane.n.y * dy + plane.n.z * dz;
    }
}

