/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.point.Point3D_F64;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class UtilPoint3D_F64 {
    public static double distance(double x0, double y0, double z0, double x1, double y1, double z1) {
        return UtilPoint3D_F64.norm(x1 - x0, y1 - y0, z1 - z0);
    }

    public static double distanceSq(double x0, double y0, double z0, double x1, double y1, double z1) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        double dz = z1 - z0;
        return dx * dx + dy * dy + dz * dz;
    }

    public static double norm(double x, double y, double z) {
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static List<Point3D_F64> copy(List<Point3D_F64> pts) {
        ArrayList<Point3D_F64> ret = new ArrayList<Point3D_F64>();
        for (Point3D_F64 p : pts) {
            ret.add(p.copy());
        }
        return ret;
    }

    public static void noiseNormal(List<Point3D_F64> pts, double sigma, Random rand) {
        for (Point3D_F64 p : pts) {
            p.x += rand.nextGaussian() * sigma;
            p.y += rand.nextGaussian() * sigma;
            p.z += rand.nextGaussian() * sigma;
        }
    }

    public static List<Point3D_F64> random(double min, double max, int num, Random rand) {
        ArrayList<Point3D_F64> ret = new ArrayList<Point3D_F64>();
        double d = max - min;
        for (int i = 0; i < num; ++i) {
            Point3D_F64 p = new Point3D_F64();
            p.x = rand.nextDouble() * d + min;
            p.y = rand.nextDouble() * d + min;
            p.z = rand.nextDouble() * d + min;
            ret.add(p);
        }
        return ret;
    }

    public static Point3D_F64 mean(List<Point3D_F64> points) {
        Point3D_F64 mean = new Point3D_F64();
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (Point3D_F64 p : points) {
            x += p.x;
            y += p.y;
            z += p.z;
        }
        mean.x = x / (double)points.size();
        mean.y = y / (double)points.size();
        mean.z = z / (double)points.size();
        return mean;
    }

    public static Point3D_F64 mean(List<Point3D_F64> points, int num) {
        Point3D_F64 mean = new Point3D_F64();
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (int i = 0; i < num; ++i) {
            Point3D_F64 p = points.get(i);
            x += p.x;
            y += p.y;
            z += p.z;
        }
        mean.x = x / (double)num;
        mean.y = y / (double)num;
        mean.z = z / (double)num;
        return mean;
    }
}

