/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.geometry.UtilPoint3D_F32;
import georegression.metric.MiscOps;
import georegression.struct.line.LineParametric3D_F32;
import georegression.struct.plane.PlaneGeneral3D_F32;
import georegression.struct.point.Point3D_F32;

public class Distance3D_F32 {
    public static float distance(LineParametric3D_F32 l0, LineParametric3D_F32 l1) {
        float x = l0.p.x - l1.p.x;
        float y = l0.p.y - l1.p.y;
        float z = l0.p.z - l1.p.z;
        float dv01v1 = MiscOps.dot(x, y, z, l1.slope);
        float dv1v0 = MiscOps.dot(l1.slope, l0.slope);
        float dv1v1 = MiscOps.dot(l1.slope, l1.slope);
        float bottom = MiscOps.dot(l0.slope, l0.slope) * dv1v1 - dv1v0 * dv1v0;
        float t0 = bottom == 0.0f ? 0.0f : (dv01v1 * dv1v0 - MiscOps.dot(x, y, z, l0.slope) * dv1v1) / bottom;
        float t1 = (dv01v1 + t0 * dv1v0) / dv1v1;
        float dx = l0.p.x + t0 * l0.slope.x - (l1.p.x + t1 * l1.slope.x);
        float dy = l0.p.y + t0 * l0.slope.y - (l1.p.y + t1 * l1.slope.y);
        float dz = l0.p.z + t0 * l0.slope.z - (l1.p.z + t1 * l1.slope.z);
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static float distance(LineParametric3D_F32 l, Point3D_F32 p) {
        float x = l.p.x - p.x;
        float y = l.p.y - p.y;
        float z = l.p.z - p.z;
        float c = UtilPoint3D_F32.norm(x, y, z);
        float b = MiscOps.dot(x, y, z, l.slope) / l.slope.norm();
        return (float)Math.sqrt(c * c - b * b);
    }

    public static float distance(PlaneGeneral3D_F32 plane, Point3D_F32 point) {
        float top = plane.A * point.x + plane.B * point.y + plane.C * point.z - plane.D;
        return top / (float)Math.sqrt(plane.A * plane.A + plane.B * plane.B + plane.C * plane.C);
    }
}

