/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.geometry.GeometryMath_F32;
import georegression.struct.line.LineParametric3D_F32;
import georegression.struct.plane.PlaneGeneral3D_F32;
import georegression.struct.plane.PlaneNormal3D_F32;
import georegression.struct.point.Point3D_F32;

public class Intersection3D_F32 {
    public static boolean intersect(PlaneNormal3D_F32 plane, LineParametric3D_F32 line, Point3D_F32 intersection) {
        float dx = plane.p.x - line.p.x;
        float dy = plane.p.y - line.p.y;
        float dz = plane.p.z - line.p.z;
        float top = dx * plane.n.x + dy * plane.n.y + dz * plane.n.z;
        float bottom = line.slope.dot(plane.n);
        if (bottom == 0.0f) {
            return false;
        }
        float d = top / bottom;
        intersection.x = line.p.x + d * line.slope.x;
        intersection.y = line.p.y + d * line.slope.y;
        intersection.z = line.p.z + d * line.slope.z;
        return true;
    }

    public static boolean intersect(PlaneGeneral3D_F32 plane, LineParametric3D_F32 line, Point3D_F32 intersection) {
        float top = plane.D - plane.A * line.p.x - plane.B * line.p.y - plane.C * line.p.z;
        float bottom = plane.A * line.slope.x + plane.B * line.slope.y + plane.C * line.slope.z;
        if (bottom == 0.0f) {
            return false;
        }
        float d = top / bottom;
        intersection.x = line.p.x + d * line.slope.x;
        intersection.y = line.p.y + d * line.slope.y;
        intersection.z = line.p.z + d * line.slope.z;
        return true;
    }

    public static boolean intersect(PlaneGeneral3D_F32 a, PlaneGeneral3D_F32 b, LineParametric3D_F32 line) {
        GeometryMath_F32.cross(a.A, a.B, a.C, b.A, b.B, b.C, line.slope);
        if (line.slope.normSq() == 0.0f) {
            return false;
        }
        float n2 = a.A * a.A + a.B * a.B + a.C * a.C;
        float closestX = a.A * a.D / n2;
        float closestY = a.B * a.D / n2;
        float closestZ = a.C * a.D / n2;
        float slopeX = a.B * line.slope.z - a.C * line.slope.y;
        float slopeY = a.C * line.slope.x - a.A * line.slope.z;
        float slopeZ = a.A * line.slope.y - a.B * line.slope.x;
        float top = b.D - b.A * closestX - b.B * closestY - b.C * closestZ;
        float bottom = b.A * slopeX + b.B * slopeY + b.C * slopeZ;
        float d = top / bottom;
        line.p.x = closestX + d * slopeX;
        line.p.y = closestY + d * slopeY;
        line.p.z = closestZ + d * slopeZ;
        return true;
    }
}

