/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.geometry.GeometryMath_F64;
import georegression.struct.line.LineParametric3D_F64;
import georegression.struct.plane.PlaneGeneral3D_F64;
import georegression.struct.plane.PlaneNormal3D_F64;
import georegression.struct.point.Point3D_F64;

public class Intersection3D_F64 {
    public static boolean intersect(PlaneNormal3D_F64 plane, LineParametric3D_F64 line, Point3D_F64 intersection) {
        double dx = plane.p.x - line.p.x;
        double dy = plane.p.y - line.p.y;
        double dz = plane.p.z - line.p.z;
        double top = dx * plane.n.x + dy * plane.n.y + dz * plane.n.z;
        double bottom = line.slope.dot(plane.n);
        if (bottom == 0.0) {
            return false;
        }
        double d = top / bottom;
        intersection.x = line.p.x + d * line.slope.x;
        intersection.y = line.p.y + d * line.slope.y;
        intersection.z = line.p.z + d * line.slope.z;
        return true;
    }

    public static boolean intersect(PlaneGeneral3D_F64 plane, LineParametric3D_F64 line, Point3D_F64 intersection) {
        double top = plane.D - plane.A * line.p.x - plane.B * line.p.y - plane.C * line.p.z;
        double bottom = plane.A * line.slope.x + plane.B * line.slope.y + plane.C * line.slope.z;
        if (bottom == 0.0) {
            return false;
        }
        double d = top / bottom;
        intersection.x = line.p.x + d * line.slope.x;
        intersection.y = line.p.y + d * line.slope.y;
        intersection.z = line.p.z + d * line.slope.z;
        return true;
    }

    public static boolean intersect(PlaneGeneral3D_F64 a, PlaneGeneral3D_F64 b, LineParametric3D_F64 line) {
        GeometryMath_F64.cross(a.A, a.B, a.C, b.A, b.B, b.C, line.slope);
        if (line.slope.normSq() == 0.0) {
            return false;
        }
        double n2 = a.A * a.A + a.B * a.B + a.C * a.C;
        double closestX = a.A * a.D / n2;
        double closestY = a.B * a.D / n2;
        double closestZ = a.C * a.D / n2;
        double slopeX = a.B * line.slope.z - a.C * line.slope.y;
        double slopeY = a.C * line.slope.x - a.A * line.slope.z;
        double slopeZ = a.A * line.slope.y - a.B * line.slope.x;
        double top = b.D - b.A * closestX - b.B * closestY - b.C * closestZ;
        double bottom = b.A * slopeX + b.B * slopeY + b.C * slopeZ;
        double d = top / bottom;
        line.p.x = closestX + d * slopeX;
        line.p.y = closestY + d * slopeY;
        line.p.z = closestZ + d * slopeZ;
        return true;
    }
}

