/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct;

import georegression.struct.GeoTuple;

public abstract class GeoTuple_F32<T extends GeoTuple_F32>
extends GeoTuple<T> {
    public boolean isIdentical(T t, float tol) {
        if (((GeoTuple)t).getDimension() != this.getDimension()) {
            return false;
        }
        int N = this.getDimension();
        for (int i = 0; i < N; ++i) {
            float diff = Math.abs(this.getIndex(i) - ((GeoTuple_F32)t).getIndex(i));
            if (!(diff > tol)) continue;
            return false;
        }
        return true;
    }

    public T copy() {
        GeoTuple_F32 ret = (GeoTuple_F32)this.createNewInstance();
        int N = this.getDimension();
        for (int i = 0; i < N; ++i) {
            ret.setIndex(i, this.getIndex(i));
        }
        return (T)ret;
    }

    public float norm() {
        return (float)Math.sqrt(this.normSq());
    }

    public float normSq() {
        float total = 0.0f;
        int N = this.getDimension();
        for (int i = 0; i < N; ++i) {
            float a = this.getIndex(i);
            total += a * a;
        }
        return total;
    }

    public float distance(T t) {
        return (float)Math.sqrt(this.distance2(t));
    }

    public float distance2(T t) {
        if (((GeoTuple)t).getDimension() != this.getDimension()) {
            throw new IllegalArgumentException("Dimension of input tuple does not match");
        }
        float total = 0.0f;
        int N = this.getDimension();
        for (int i = 0; i < N; ++i) {
            float diff = Math.abs(this.getIndex(i) - ((GeoTuple_F32)t).getIndex(i));
            total += diff * diff;
        }
        return total;
    }

    public abstract float getIndex(int var1);

    public abstract void setIndex(int var1, float var2);
}

