/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.line;

import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;

public class LineParametric3D_F64 {
    public Point3D_F64 p = new Point3D_F64();
    public Vector3D_F64 slope = new Vector3D_F64();

    public LineParametric3D_F64(double x_0, double y_0, double z_0, double slopeX, double slopeY, double slopeZ) {
        this.p.set(x_0, y_0, z_0);
        this.slope.set(slopeX, slopeY, slopeZ);
    }

    public LineParametric3D_F64(Point3D_F64 p, Vector3D_F64 slope) {
        this.setPoint(p);
        this.setSlope(slope);
    }

    public LineParametric3D_F64() {
    }

    public void setPoint(Point3D_F64 pt) {
        this.p.set(pt);
    }

    public void setPoint(double x, double y, double z) {
        this.p.x = x;
        this.p.y = y;
        this.p.z = z;
    }

    public void setSlope(Vector3D_F64 slope) {
        this.slope.set(slope);
    }

    public void setSlope(double slopeX, double slopeY, double slopeZ) {
        this.slope.x = slopeX;
        this.slope.y = slopeY;
        this.slope.z = slopeZ;
    }

    public Point3D_F64 getPointOnLine(double t) {
        return new Point3D_F64(this.slope.x * t + this.p.x, this.slope.y * t + this.p.y, this.slope.z * t + this.p.z);
    }

    public Point3D_F64 getPoint() {
        return this.p;
    }

    public Vector3D_F64 getSlope() {
        return this.slope;
    }

    public final double getSlopeX() {
        return this.slope.x;
    }

    public final double getSlopeY() {
        return this.slope.y;
    }

    public final double getSlopeZ() {
        return this.slope.y;
    }

    public final double getX() {
        return this.p.x;
    }

    public final double getY() {
        return this.p.y;
    }

    public final double getZ() {
        return this.p.y;
    }

    public LineParametric3D_F64 copy() {
        return new LineParametric3D_F64(this.p, this.slope);
    }
}

