/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.se;

import georegression.geometry.RotationMatrixGenerator;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se2_F64;
import georegression.struct.se.Se3_F64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.ops.CommonOps;

public class SpecialEuclideanOps_F64 {
    public static void setToNoMotion(Se3_F64 se) {
        CommonOps.setIdentity((RowD1Matrix64F)se.getR());
        se.getT().set(0.0, 0.0, 0.0);
    }

    public static DenseMatrix64F toHomogeneous(Se3_F64 se, DenseMatrix64F ret) {
        if (ret == null) {
            ret = new DenseMatrix64F(4, 4);
        } else {
            ret.set(3, 0, 0.0);
            ret.set(3, 1, 0.0);
            ret.set(3, 2, 0.0);
        }
        CommonOps.insert((Matrix64F)se.getR(), (Matrix64F)ret, (int)0, (int)0);
        Vector3D_F64 T = se.getT();
        ret.set(0, 3, T.x);
        ret.set(1, 3, T.y);
        ret.set(2, 3, T.z);
        ret.set(3, 3, 1.0);
        return ret;
    }

    public static Se3_F64 toSe3_F64(DenseMatrix64F H, Se3_F64 ret) {
        if (H.numCols != 4 || H.numRows != 4) {
            throw new IllegalArgumentException("The homogeneous matrix must be 4 by 4 by definition.");
        }
        if (ret == null) {
            ret = new Se3_F64();
        }
        ret.setTranslation(H.get(0, 3), H.get(1, 3), H.get(2, 3));
        CommonOps.extract((Matrix64F)H, (int)0, (int)3, (int)0, (int)3, (Matrix64F)ret.getR(), (int)0, (int)0);
        return ret;
    }

    public static DenseMatrix64F toHomogeneous(Se2_F64 se, DenseMatrix64F ret) {
        if (ret == null) {
            ret = new DenseMatrix64F(3, 3);
        } else {
            ret.set(2, 0, 0.0);
            ret.set(2, 1, 0.0);
        }
        double c = se.getCosineYaw();
        double s = se.getSineYaw();
        ret.set(0, 0, c);
        ret.set(0, 1, -s);
        ret.set(1, 0, s);
        ret.set(1, 1, c);
        ret.set(0, 2, se.getX());
        ret.set(1, 2, se.getY());
        ret.set(2, 2, 1.0);
        return ret;
    }

    public static Se2_F64 toSe2(DenseMatrix64F H, Se2_F64 ret) {
        if (H.numCols != 3 || H.numRows != 3) {
            throw new IllegalArgumentException("The homogeneous matrix must be 3 by 3 by definition.");
        }
        if (ret == null) {
            ret = new Se2_F64();
        }
        ret.setTranslation(H.get(0, 2), H.get(1, 2));
        double c = H.get(0, 0);
        double s = H.get(1, 0);
        ret.setYaw(Math.atan2(s, c));
        return ret;
    }

    public static Se3_F64 setEulerXYZ(double rotX, double rotY, double rotZ, double dx, double dy, double dz, Se3_F64 se) {
        if (se == null) {
            se = new Se3_F64();
        }
        RotationMatrixGenerator.eulerXYZ(rotX, rotY, rotZ, se.getR());
        Vector3D_F64 T = se.getT();
        T.x = dx;
        T.y = dy;
        T.z = dz;
        return se;
    }
}

