/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Range;
import adams.data.conversion.AbstractSpreadSheetConversion;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.RowIdentifier;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.statistics.StatUtils;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import java.util.List;

public class AggregateSpreadSheet
extends AbstractSpreadSheetConversion {
    private static final long serialVersionUID = -1789320708357341617L;
    protected SpreadSheetColumnRange m_KeyColumns;
    protected SpreadSheetColumnRange m_AggregateColumns;
    protected Aggregate[] m_Aggregates;

    public String globalInfo() {
        return "Aggregates rows (min, max, avg, etc) in a spreadsheet using key columns.\nAll numeric columns in the specified aggregrate range (excluding the key columns) get aggregated. For each of the specified aggregates a new column is generated.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key-columns", "keyColumns", (Object)new SpreadSheetColumnRange("first"));
        this.m_OptionManager.add("aggregate-columns", "aggregateColumns", (Object)new SpreadSheetColumnRange("first-last"));
        this.m_OptionManager.add("aggregate", "aggregates", (Object)new Aggregate[]{Aggregate.SUM});
    }

    public void setKeyColumns(SpreadSheetColumnRange value) {
        this.m_KeyColumns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getKeyColumns() {
        return this.m_KeyColumns;
    }

    public String keyColumnsTipText() {
        return "The columns to use as keys for identifying rows in the spreadsheets; " + this.m_KeyColumns.getExample();
    }

    public void setAggregateColumns(SpreadSheetColumnRange value) {
        this.m_AggregateColumns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getAggregateColumns() {
        return this.m_AggregateColumns;
    }

    public String aggregateColumnsTipText() {
        return "The columns to aggregate (only numeric ones will be used); " + this.m_KeyColumns.getExample();
    }

    public void setAggregates(Aggregate[] value) {
        this.m_Aggregates = value;
        this.reset();
    }

    public Aggregate[] getAggregates() {
        return this.m_Aggregates;
    }

    public String aggregatesTipText() {
        return "The aggregates to calculate and introduce as columns.";
    }

    protected double computeAggregate(SpreadSheet input, List<Integer> subset, Row rowNew, int index, Aggregate agg) {
        double result = Double.NaN;
        double[] values = new double[subset.size()];
        for (int i = 0; i < subset.size(); ++i) {
            Cell cell = input.getCell(subset.get(i).intValue(), index);
            values[i] = cell != null && cell.isNumeric() ? cell.toDouble() : 0.0;
        }
        if (values.length > 0) {
            switch (agg) {
                case SUM: {
                    result = StatUtils.sum((double[])values);
                    break;
                }
                case MIN: {
                    result = StatUtils.min((double[])values);
                    break;
                }
                case MAX: {
                    result = StatUtils.max((double[])values);
                    break;
                }
                case AVERAGE: {
                    result = StatUtils.mean((double[])values);
                    break;
                }
                case MEDIAN: {
                    result = StatUtils.median((double[])values);
                    break;
                }
                case STDEV: {
                    result = StatUtils.stddev((double[])values, (boolean)true);
                    break;
                }
                case STDEVP: {
                    result = StatUtils.stddev((double[])values, (boolean)false);
                    break;
                }
                case INTERQUARTILE: {
                    result = StatUtils.iqr((double[])values);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled aggregate: " + (Object)((Object)agg));
                }
            }
        }
        return result;
    }

    @Override
    protected SpreadSheet convert(SpreadSheet input) throws Exception {
        this.m_KeyColumns.setSpreadSheet(input);
        int[] keys = this.m_KeyColumns.getIntIndices();
        if (keys.length == 0) {
            throw new IllegalStateException("No key columns defined!");
        }
        RowIdentifier rows = new RowIdentifier((Range)this.m_KeyColumns);
        this.m_AggregateColumns.setSpreadSheet(input);
        int[] agg = this.m_AggregateColumns.getIntIndices();
        TIntHashSet numeric = new TIntHashSet();
        for (int index : agg) {
            if (this.m_KeyColumns.isInRange(index) || !input.isNumeric(index)) continue;
            numeric.add(index);
        }
        agg = numeric.toArray();
        Arrays.sort(agg);
        rows.identify(input);
        SpreadSheet result = input.newInstance();
        result.setDataRowClass(input.getDataRowClass());
        HeaderRow row = result.getHeaderRow();
        for (int index : keys) {
            row.addCell("" + index).setContent(input.getHeaderRow().getCell(index).getContent());
        }
        for (int index : agg) {
            for (Aggregate a : this.m_Aggregates) {
                row.addCell("" + index + "-" + (Object)((Object)a)).setContent(input.getHeaderRow().getCell(index).getContent() + "-" + (Object)((Object)a));
            }
        }
        for (String key : rows.getKeys()) {
            DataRow rowNew = result.addRow();
            List subset = rows.getRows(key);
            for (int index : keys) {
                rowNew.addCell("" + index).setContent(input.getRow(((Integer)subset.get(0)).intValue()).getCell(index).getContent());
            }
            for (int index : agg) {
                for (Aggregate a : this.m_Aggregates) {
                    rowNew.addCell("" + index + "-" + (Object)((Object)a)).setContent(Double.valueOf(this.computeAggregate(input, subset, (Row)rowNew, index, a)));
                }
            }
        }
        return result;
    }

    public static enum Aggregate {
        SUM,
        MIN,
        MAX,
        AVERAGE,
        MEDIAN,
        STDEV,
        STDEVP,
        INTERQUARTILE;

    }
}

