/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractSpreadSheetConversion;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DataRowType;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;

public class ConvertSpreadSheetRows
extends AbstractSpreadSheetConversion {
    private static final long serialVersionUID = 1779359599048268798L;
    protected DataRowType m_DataRowType;

    public String globalInfo() {
        return "Converts the rows in the spreadsheet into a new format.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("data-row-type", "dataRowType", (Object)DataRowType.DENSE);
    }

    public void setDataRowType(DataRowType value) {
        this.m_DataRowType = value;
        this.reset();
    }

    public DataRowType getDataRowType() {
        return this.m_DataRowType;
    }

    public String dataRowTypeTipText() {
        return "The type of row to use for the data.";
    }

    @Override
    protected SpreadSheet convert(SpreadSheet input) throws Exception {
        SpreadSheet result = input.getHeader();
        result.setDataRowClass(this.m_DataRowType.getRowClass());
        for (Row rowOld : input.rows()) {
            DataRow rowNew = result.addRow();
            for (String key : rowOld.cellKeys()) {
                Cell cell = rowOld.getCell(key);
                if (cell == null || cell.isMissing()) continue;
                rowNew.addCell(key).assign(cell);
            }
        }
        return result;
    }
}

