/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.DataRowType;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;

public class DoubleMatrixToSpreadSheet
extends AbstractConversion {
    private static final long serialVersionUID = -2047404866165517428L;
    protected DataRowType m_DataRowType;
    protected SpreadSheet m_SpreadSheetType;

    public String globalInfo() {
        return "Converts a double matrix into a SpreadSheet object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("data-row-type", "dataRowType", (Object)DataRowType.DENSE);
        this.m_OptionManager.add("spreadsheet-type", "spreadSheetType", (Object)new SpreadSheet());
    }

    public void setDataRowType(DataRowType value) {
        this.m_DataRowType = value;
        this.reset();
    }

    public DataRowType getDataRowType() {
        return this.m_DataRowType;
    }

    public String dataRowTypeTipText() {
        return "The type of row to use for the data.";
    }

    public void setSpreadSheetType(SpreadSheet value) {
        this.m_SpreadSheetType = value;
        this.reset();
    }

    public SpreadSheet getSpreadSheetType() {
        return this.m_SpreadSheetType;
    }

    public String spreadSheetTypeTipText() {
        return "The type of spreadsheet to use for the data.";
    }

    public Class accepts() {
        return Double[][].class;
    }

    public Class generates() {
        if (this.m_SpreadSheetType != null) {
            return this.m_SpreadSheetType.getClass();
        }
        return SpreadSheet.class;
    }

    protected Object doConvert() throws Exception {
        int i;
        SpreadSheet result = this.m_SpreadSheetType.newInstance();
        result.setDataRowClass(this.m_DataRowType.getRowClass());
        Double[][] matrix = (Double[][])this.getInput();
        HeaderRow row = result.getHeaderRow();
        for (i = 0; i < matrix[0].length; ++i) {
            row.addCell("" + (i + 1)).setContent("col-" + (i + 1));
        }
        for (int n = 0; n < matrix.length; ++n) {
            row = result.addRow("" + (n + 1));
            for (i = 0; i < matrix[0].length; ++i) {
                row.addCell("" + (i + 1)).setContent(matrix[n][i]);
            }
        }
        return result;
    }
}

