/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.io.output.MultiSheetSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.sink.AbstractFileWriter;
import java.io.File;

public class SpreadSheetFileWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = 393925191813730213L;
    protected SpreadSheetWriter m_Writer;

    public String globalInfo() {
        return "Actor that writes SpreadSheet objects to files.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("writer", "writer", (Object)new CsvSpreadSheetWriter());
    }

    protected void reset() {
        super.reset();
        if (this.m_Writer != null) {
            this.m_Writer.reset();
        }
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"writer", (Object)this.m_Writer);
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputFile", (Object)this.m_OutputFile, (String)", file: ");
        return result;
    }

    protected PlaceholderFile getDefaultOutputFile() {
        return new PlaceholderFile("${TMP}/out.csv");
    }

    public String outputFileTipText() {
        return "The name of the output file.";
    }

    public void setWriter(SpreadSheetWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public SpreadSheetWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The writer for storing the spreadsheet.";
    }

    public Class[] accepts() {
        if (this.m_Writer instanceof MultiSheetSpreadSheetWriter) {
            return new Class[]{SpreadSheet[].class, SpreadSheet.class};
        }
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        String result = null;
        if (this.m_InputToken.getPayload() instanceof SpreadSheet) {
            SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
            if (!this.m_Writer.write(sheet, (File)this.m_OutputFile)) {
                result = "Problems writing spreadsheet to '" + this.m_OutputFile + "'!";
            }
        } else {
            SpreadSheet[] sheets = (SpreadSheet[])this.m_InputToken.getPayload();
            if (!((MultiSheetSpreadSheetWriter)this.m_Writer).write(sheets, (File)this.m_OutputFile)) {
                result = "Problems writing spreadsheets to '" + this.m_OutputFile + "'!";
            }
        }
        return result;
    }
}

