/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.plotgenerator.AbstractPlotGenerator;
import adams.flow.transformer.plotgenerator.XYPlotGenerator;
import java.util.ArrayList;
import java.util.List;

public class SpreadSheetPlotGenerator
extends AbstractTransformer {
    private static final long serialVersionUID = 1147935218531182101L;
    protected AbstractPlotGenerator m_Generator;
    protected List<SequencePlotterContainer> m_Containers;

    public String globalInfo() {
        return "Outputs plot containers generated from a spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new XYPlotGenerator());
    }

    protected void initialize() {
        super.initialize();
        this.m_Containers = new ArrayList<SequencePlotterContainer>();
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"generator", (Object)((Object)this.m_Generator), (String)"generator: ");
    }

    public void setGenerator(AbstractPlotGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractPlotGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The plot generator to use.";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        try {
            this.m_Containers = this.m_Generator.generate(sheet);
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate plot containers with " + OptionUtils.getCommandLine((Object)((Object)this.m_Generator)), e);
        }
        return result;
    }

    public Class[] generates() {
        return new Class[]{SequencePlotterContainer.class};
    }

    public boolean hasPendingOutput() {
        return this.m_Containers.size() > 0;
    }

    public Token output() {
        Token result = new Token((Object)this.m_Containers.get(0));
        this.m_InputToken = null;
        this.m_Containers.remove(0);
        return result;
    }
}

