/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer;

import adams.core.CleanUpHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.flow.control.Flow;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.SearchPanel;
import adams.gui.core.SpreadSheetColumnComboBox;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.core.TableRowRange;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.tools.SpreadSheetViewerPanel;
import adams.gui.tools.spreadsheetviewer.TabbedPane;
import adams.gui.tools.spreadsheetviewer.chart.AbstractChartGenerator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class SpreadSheetPanel
extends BasePanel
implements SpreadSheetSupporter,
CleanUpHandler {
    private static final long serialVersionUID = -4251007424174062651L;
    protected TabbedPane m_Owner;
    protected SpreadSheetTable m_Table;
    protected SpreadSheetColumnComboBox m_ColumnComboBox;
    protected SearchPanel m_PanelSearch;
    protected List<Flow> m_Charts;

    public SpreadSheetPanel(TabbedPane owner) {
        this.setOwner(owner);
    }

    protected void initialize() {
        super.initialize();
        this.m_Charts = new ArrayList<Flow>();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Table = new SpreadSheetTable(new SpreadSheetTableModel());
        this.m_Table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SpreadSheetPanel.this.getViewer() != null) {
                    SpreadSheetPanel.this.getViewer().getViewerTabs().notifyTabs(SpreadSheetPanel.this, SpreadSheetPanel.this.m_Table.getSelectedRows());
                }
            }
        });
        this.add((Component)new BaseScrollPane((Component)this.m_Table), "Center");
        JPanel panel = new JPanel(new FlowLayout(2));
        this.m_ColumnComboBox = new SpreadSheetColumnComboBox(this.m_Table);
        panel.add((Component)this.m_ColumnComboBox);
        this.add(panel, "North");
        this.m_PanelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
        this.m_PanelSearch.addSearchListener(new SearchListener(){

            public void searchInitiated(SearchEvent e) {
                SpreadSheetPanel.this.m_Table.search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
            }
        });
        this.add((Component)this.m_PanelSearch, "South");
    }

    public void setOwner(TabbedPane value) {
        this.m_Owner = value;
    }

    public TabbedPane getOwner() {
        return this.m_Owner;
    }

    public String getTabTitle() {
        int index;
        String result = null;
        if (this.getOwner() != null && (index = this.getOwner().indexOfComponent((Component)((Object)this))) > -1) {
            result = this.getOwner().getTitleAt(index);
        }
        return result;
    }

    public SpreadSheetViewerPanel getViewer() {
        if (this.getOwner() != null) {
            return this.getOwner().getOwner();
        }
        return null;
    }

    public void setNumDecimals(int value) {
        this.m_Table.setNumDecimals(value);
    }

    public int getNumDecimals() {
        return this.m_Table.getNumDecimals();
    }

    public boolean hasNegativeBackground() {
        return this.m_Table.hasNegativeBackground();
    }

    public void setNegativeBackground(Color value) {
        this.m_Table.setNegativeBackground(value);
    }

    public Color getNegativeBackground() {
        return this.m_Table.getNegativeBackground();
    }

    public boolean hasPositiveBackground() {
        return this.m_Table.hasPositiveBackground();
    }

    public void setPositiveBackground(Color value) {
        this.m_Table.setPositiveBackground(value);
    }

    public Color getPositiveBackground() {
        return this.m_Table.getPositiveBackground();
    }

    public void setShowFormulas(boolean value) {
        this.m_Table.setShowFormulas(value);
    }

    public boolean getShowFormulas() {
        return this.m_Table.getShowFormulas();
    }

    public SpreadSheetTable getTable() {
        return this.m_Table;
    }

    public void setSheet(SpreadSheet value) {
        this.m_Table.setModel((TableModel)new SpreadSheetTableModel(value));
    }

    public SpreadSheet getSheet() {
        return this.toSpreadSheet();
    }

    public SpreadSheet toSpreadSheet() {
        return this.m_Table.toSpreadSheet();
    }

    public SpreadSheet toSpreadSheet(TableRowRange range) {
        return this.m_Table.toSpreadSheet(range);
    }

    public void generateChart(AbstractChartGenerator generator) {
        final Flow flow = generator.generate(this.getTabTitle(), this.getSheet());
        flow.setParentComponent((Component)((Object)this));
        SwingWorker worker = new SwingWorker(){
            String msg = null;

            protected Object doInBackground() throws Exception {
                this.msg = flow.setUp();
                if (this.msg != null) {
                    this.msg = "Failed to setup flow for generating chart:\n" + this.msg;
                }
                if (this.msg == null) {
                    this.msg = flow.execute();
                    if (this.msg != null) {
                        this.msg = "Failed to execute flow for generating chart:\n" + this.msg;
                    }
                }
                if (this.msg == null) {
                    flow.wrapUp();
                    if (flow.hasStopMessage()) {
                        this.msg = "Flow execution for generating chart was stopped:\n" + flow.getStopMessage();
                    }
                }
                return this.msg;
            }

            @Override
            protected void done() {
                super.done();
                if (this.msg != null) {
                    GUIHelper.showErrorMessage((Component)((Object)SpreadSheetPanel.this), (String)this.msg);
                    ConsolePanel.getSingleton().append(ConsolePanel.OutputType.ERROR, this.msg);
                    ConsolePanel.getSingleton().append(ConsolePanel.OutputType.ERROR, flow.toCommandLine());
                    flow.destroy();
                } else {
                    SpreadSheetPanel.this.m_Charts.add(flow);
                }
            }
        };
        worker.execute();
    }

    public void cleanUp() {
        for (Flow flow : this.m_Charts) {
            flow.destroy();
        }
        this.m_Charts.clear();
    }
}

