/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.flattener;

import adams.core.base.BaseText;
import adams.core.io.PlaceholderFile;
import adams.core.scripting.FileBasedScriptingWithOptions;
import adams.data.image.BufferedImageContainer;
import adams.data.jai.flattener.AbstractJAIFlattener;

public abstract class AbstractScriptedFlattener
extends AbstractJAIFlattener
implements FileBasedScriptingWithOptions {
    private static final long serialVersionUID = -8187233244973711251L;
    protected PlaceholderFile m_ScriptFile;
    protected String m_ScriptOptions;
    protected transient Object m_ScriptObject;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("script", "scriptFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("options", "scriptOptions", (Object)new BaseText());
    }

    @Override
    public void reset() {
        super.reset();
        this.m_ScriptObject = null;
    }

    public void setScriptFile(PlaceholderFile value) {
        this.m_ScriptFile = value;
        this.reset();
    }

    public PlaceholderFile getScriptFile() {
        return this.m_ScriptFile;
    }

    public String scriptFileTipText() {
        return "The script file to load and execute.";
    }

    public void setScriptOptions(BaseText value) {
        this.m_ScriptOptions = value.getValue();
        this.reset();
    }

    public BaseText getScriptOptions() {
        return new BaseText(this.m_ScriptOptions);
    }

    public String scriptOptionsTipText() {
        return "The options for the script.";
    }

    protected abstract String loadScriptObject();

    protected abstract String checkScriptObject();

    protected String initScriptObject() {
        String result = this.loadScriptObject();
        if (result == null) {
            result = this.checkScriptObject();
        }
        return result;
    }

    @Override
    protected void checkImage(BufferedImageContainer img) {
        super.checkImage(img);
        String msg = this.initScriptObject();
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_ScriptObject = null;
    }
}

