/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.flattener;

import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.jai.flattener.AbstractJAIFlattener;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class Pixels
extends AbstractJAIFlattener {
    private static final long serialVersionUID = -8349656592325229512L;
    protected PixelType m_PixelType;

    public String globalInfo() {
        return "Gets all the pixels of the image.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("pixel-type", "pixelType", (Object)PixelType.RGB_SINGLE);
    }

    public void setPixelType(PixelType value) {
        this.m_PixelType = value;
        this.reset();
    }

    public PixelType getPixelType() {
        return this.m_PixelType;
    }

    public String pixelTypeTipText() {
        return "The pixel type to use.";
    }

    @Override
    public Instances createHeader(BufferedImageContainer img) {
        int numPixels = img.getWidth() * img.getHeight();
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        block5: for (int i = 0; i < numPixels; ++i) {
            switch (this.m_PixelType) {
                case RGB_SINGLE: 
                case LUMINANCE_STANDARD: 
                case LUMINANCE_PERCEIVED1: 
                case LUMINANCE_PERCEIVED2: {
                    atts.add(new Attribute("att_" + (i + 1)));
                    continue block5;
                }
                case RGB_SEPARATE: {
                    atts.add(new Attribute("att_r_" + (i + 1)));
                    atts.add(new Attribute("att_g_" + (i + 1)));
                    atts.add(new Attribute("att_b_" + (i + 1)));
                    continue block5;
                }
                case HSB_SEPARATE: {
                    atts.add(new Attribute("att_h_" + (i + 1)));
                    atts.add(new Attribute("att_s_" + (i + 1)));
                    atts.add(new Attribute("att_b_" + (i + 1)));
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Unhandled pixel type: " + (Object)((Object)this.m_PixelType));
                }
            }
        }
        Instances result = new Instances(this.getClass().getName(), atts, 0);
        return result;
    }

    @Override
    public Instance[] doFlatten(BufferedImageContainer img) {
        Instance[] result = null;
        double[] values = this.newArray(this.m_Header.numAttributes());
        switch (this.m_PixelType) {
            case RGB_SINGLE: {
                if (((BufferedImage)img.getImage()).getType() == 10) {
                    int[][] rgbas = BufferedImageHelper.getRGBPixels((BufferedImage)((BufferedImage)img.getImage()));
                    for (int i = 0; i < rgbas.length; ++i) {
                        values[i] = rgbas[i][0];
                    }
                } else {
                    int[] pixels = BufferedImageHelper.getPixels((BufferedImage)((BufferedImage)img.getImage()));
                    for (int i = 0; i < pixels.length; ++i) {
                        values[i] = pixels[i];
                    }
                }
                break;
            }
            case RGB_SEPARATE: {
                int[][] rgbas = BufferedImageHelper.getRGBPixels((BufferedImage)((BufferedImage)img.getImage()));
                for (int i = 0; i < rgbas.length; ++i) {
                    values[i * 3 + 0] = rgbas[i][0];
                    values[i * 3 + 1] = rgbas[i][1];
                    values[i * 3 + 2] = rgbas[i][2];
                }
                break;
            }
            case HSB_SEPARATE: {
                float[] hsb = new float[3];
                int[][] rgbas = BufferedImageHelper.getRGBPixels((BufferedImage)((BufferedImage)img.getImage()));
                for (int i = 0; i < rgbas.length; ++i) {
                    hsb = Color.RGBtoHSB(rgbas[i][0], rgbas[i][1], rgbas[i][2], hsb);
                    values[i * 3 + 0] = hsb[0];
                    values[i * 3 + 1] = hsb[1];
                    values[i * 3 + 2] = hsb[2];
                }
                break;
            }
            case LUMINANCE_STANDARD: {
                int[][] rgbas = BufferedImageHelper.getRGBPixels((BufferedImage)((BufferedImage)img.getImage()));
                for (int i = 0; i < rgbas.length; ++i) {
                    values[i] = (double)rgbas[i][0] * 0.2126 + (double)rgbas[i][1] * 0.7152 + (double)rgbas[i][2] * 0.0722;
                }
                break;
            }
            case LUMINANCE_PERCEIVED1: {
                int[][] rgbas = BufferedImageHelper.getRGBPixels((BufferedImage)((BufferedImage)img.getImage()));
                for (int i = 0; i < rgbas.length; ++i) {
                    values[i] = (double)rgbas[i][0] * 0.299 + (double)rgbas[i][1] * 0.587 + (double)rgbas[i][2] * 0.114;
                }
                break;
            }
            case LUMINANCE_PERCEIVED2: {
                int[][] rgbas = BufferedImageHelper.getRGBPixels((BufferedImage)((BufferedImage)img.getImage()));
                for (int i = 0; i < rgbas.length; ++i) {
                    values[i] = Math.sqrt((double)(rgbas[i][0] * rgbas[i][0]) * 0.241 + (double)(rgbas[i][1] * rgbas[i][1]) * 0.691 + (double)(rgbas[i][2] * rgbas[i][2]) * 0.068);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled pixel type: " + (Object)((Object)this.m_PixelType));
            }
        }
        result = new Instance[]{new DenseInstance(1.0, values)};
        result[0].setDataset(this.m_Header);
        return result;
    }

    public static enum PixelType {
        RGB_SINGLE,
        RGB_SEPARATE,
        HSB_SEPARATE,
        LUMINANCE_STANDARD,
        LUMINANCE_PERCEIVED1,
        LUMINANCE_PERCEIVED2;

    }
}

