/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer.crop;

import adams.core.option.AbstractOptionHandler;
import adams.data.image.CropAlgorithm;
import java.awt.Point;
import java.awt.image.BufferedImage;

public abstract class AbstractCropAlgorithm
extends AbstractOptionHandler
implements CropAlgorithm<BufferedImage> {
    private static final long serialVersionUID = 776508705083560079L;
    protected Point m_TopLeft;
    protected Point m_BottomRight;

    protected void check(BufferedImage img) {
        if (img == null) {
            throw new IllegalStateException("No image supplied!");
        }
    }

    protected void preCrop(BufferedImage img) {
        this.m_TopLeft = new Point(0, 0);
        this.m_BottomRight = new Point(img.getWidth(), img.getHeight());
    }

    protected abstract BufferedImage doCrop(BufferedImage var1);

    protected void postCrop(BufferedImage img) {
    }

    @Override
    public BufferedImage crop(BufferedImage img) {
        this.check(img);
        this.preCrop(img);
        BufferedImage result = this.doCrop(img);
        this.postCrop(result);
        return result;
    }

    @Override
    public Point getTopLeft() {
        return this.m_TopLeft;
    }

    @Override
    public Point getBottomRight() {
        return this.m_BottomRight;
    }
}

