/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.data.conversion.WekaInstanceToAdamsInstance;
import adams.data.instance.Instance;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.plugins.AbstractSelectedImagesViewerPluginWithGOE;
import adams.gui.visualization.instance.InstanceContainer;
import adams.gui.visualization.instance.InstanceContainerManager;
import adams.gui.visualization.instance.InstanceExplorer;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

public abstract class AbstractSelectedImagesFlattener
extends AbstractSelectedImagesViewerPluginWithGOE {
    private static final long serialVersionUID = -3111612432359476318L;
    protected String m_FilterError;
    protected List<weka.core.Instance> m_Collected;

    public boolean canExecute(ImagePanel panel) {
        return panel != null && panel.getCurrentImage() != null;
    }

    protected String getDialogTitle() {
        String result = this.getLastSetup().getClass().getSimpleName();
        if (this.m_CurrentPanel.getCurrentFile() != null) {
            result = result + " [" + this.m_CurrentPanel.getCurrentFile().getName() + " -- " + this.m_CurrentPanel.getCurrentFile().getParent() + "]";
        }
        return result;
    }

    protected Dimension getDialogSize() {
        return new Dimension(800, 600);
    }

    protected String processInit() {
        String result = super.processInit();
        if (result == null) {
            this.m_Collected = new ArrayList<weka.core.Instance>();
        }
        return result;
    }

    protected abstract weka.core.Instance[] flatten(BufferedImage var1);

    protected String process(ImagePanel panel) {
        String result = null;
        BufferedImage input = panel.getCurrentImage();
        try {
            weka.core.Instance[] output = this.flatten(input);
            this.m_Collected.addAll(Arrays.asList(output));
            if (this.m_CanceledByUser) {
                return result;
            }
            if (output == null) {
                result = "Failed to flatten image: ";
                result = this.m_FilterError == null ? result + "unknown reason" : result + this.m_FilterError;
            }
        }
        catch (Exception e) {
            this.m_FilterError = e.toString();
            result = "Failed to flatten image: ";
            this.getLogger().log(Level.SEVERE, result, e);
            result = result + this.m_FilterError;
        }
        return result;
    }

    protected String processFinish() {
        String result = super.processFinish();
        if (result == null) {
            ApprovalDialog dlg = this.m_CurrentPanel.getParentDialog() != null ? new ApprovalDialog(this.m_CurrentPanel.getParentDialog(), Dialog.ModalityType.MODELESS) : new ApprovalDialog(this.m_CurrentPanel.getParentFrame(), false);
            this.m_CurrentPanel.addDependentDialog((Dialog)dlg);
            InstanceExplorer explorer = new InstanceExplorer();
            InstanceContainerManager manager = explorer.getContainerManager();
            manager.startUpdate();
            WekaInstanceToAdamsInstance conv = new WekaInstanceToAdamsInstance();
            for (weka.core.Instance inst : this.m_Collected) {
                conv.setInput((Object)inst);
                if (conv.convert() != null) continue;
                Instance ainst = (Instance)conv.getOutput();
                InstanceContainer cont = manager.newContainer((Comparable)ainst);
                if (this.m_CurrentPanel.getCurrentFile() != null) {
                    cont.setID(this.m_CurrentPanel.getCurrentFile().getName());
                    cont.getData().getReport().setStringValue("File", this.m_CurrentPanel.getCurrentFile().getName());
                    cont.getData().getReport().setStringValue("Path", this.m_CurrentPanel.getCurrentFile().getParent());
                    cont.getData().getReport().setStringValue("Full", this.m_CurrentPanel.getCurrentFile().getAbsolutePath());
                }
                manager.add(cont);
            }
            conv.cleanUp();
            manager.finishUpdate();
            dlg.setTitle(this.getDialogTitle());
            dlg.setApproveVisible(true);
            dlg.setCancelVisible(false);
            dlg.setDiscardVisible(false);
            dlg.getContentPane().add((Component)explorer, "Center");
            dlg.setSize(this.getDialogSize());
            dlg.setLocationRelativeTo(null);
            dlg.setVisible(true);
        }
        return result;
    }
}

