/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.weka.predictions.AbstractErrorScaler;
import adams.data.weka.predictions.AutoScaler;
import adams.flow.container.WekaEvaluationContainer;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JComponent;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.Prediction;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;

public class WekaClassifierErrors
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = 3247255046513744115L;
    protected VisualizePanel m_VisualizePanel;
    protected AbstractErrorScaler m_ErrorScaler;

    public String globalInfo() {
        return "Actor for displaying classifier errors.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("scaler", "errorScaler", (Object)new AutoScaler());
    }

    protected int getDefaultWidth() {
        return 640;
    }

    protected int getDefaultHeight() {
        return 480;
    }

    public void setErrorScaler(AbstractErrorScaler value) {
        this.m_ErrorScaler = value;
        this.reset();
    }

    public AbstractErrorScaler getErrorScaler() {
        return this.m_ErrorScaler;
    }

    public String errorScalerTipText() {
        return "The scaler to use for scaling the errors.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"errorScaler", (Object)Utils.shorten((String)OptionUtils.getShortCommandLine((Object)((Object)this.m_ErrorScaler)), (int)40), (String)", error scaler: ");
        return result;
    }

    public void clearPanel() {
        if (this.m_VisualizePanel != null) {
            this.m_VisualizePanel.removeAllPlots();
        }
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        this.m_VisualizePanel = new VisualizePanel();
        result.add((Component)this.m_VisualizePanel, (Object)"Center");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Evaluation.class, WekaEvaluationContainer.class};
    }

    protected void display(Token token) {
        try {
            Evaluation eval = token.getPayload() instanceof WekaEvaluationContainer ? (Evaluation)((WekaEvaluationContainer)((Object)token.getPayload())).getValue("Evaluation") : (Evaluation)token.getPayload();
            if (eval.predictions() == null) {
                this.getLogger().severe("No predictions available from Evaluation object!");
                return;
            }
            DataGenerator generator = new DataGenerator(eval, this.m_ErrorScaler);
            PlotData2D plotdata = generator.getPlotData();
            plotdata.setPlotName(generator.getPlotInstances().relationName());
            this.m_VisualizePanel.addPlot(plotdata);
            this.m_VisualizePanel.setColourIndex(plotdata.getPlotInstances().classIndex());
            if (this.m_VisualizePanel.getXIndex() == 0 && this.m_VisualizePanel.getYIndex() == 1) {
                try {
                    this.m_VisualizePanel.setXIndex(this.m_VisualizePanel.getInstances().classIndex());
                    this.m_VisualizePanel.setYIndex(this.m_VisualizePanel.getInstances().classIndex() - 1);
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            this.handleException("Failed to display token: " + token, e);
        }
    }

    protected void cleanUpGUI() {
        if (this.m_VisualizePanel != null) {
            this.m_VisualizePanel.removeAllPlots();
            this.m_VisualizePanel = null;
        }
        super.cleanUpGUI();
    }

    protected Evaluation getEvaluation(Token token) {
        if (token.getPayload() instanceof WekaEvaluationContainer) {
            return (Evaluation)((WekaEvaluationContainer)((Object)token.getPayload())).getValue("Evaluation");
        }
        return (Evaluation)token.getPayload();
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        String name = token != null ? "Classifier errors (" + this.getEvaluation(token).getHeader().relationName() + ")" : "Classifier errors";
        AbstractComponentDisplayPanel result = new AbstractComponentDisplayPanel(name){
            private static final long serialVersionUID = -7362768698548152899L;
            protected VisualizePanel m_VisualizePanel;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_VisualizePanel = new VisualizePanel();
                this.add((Component)this.m_VisualizePanel, "Center");
            }

            public void display(Token token) {
                try {
                    Evaluation eval = WekaClassifierErrors.this.getEvaluation(token);
                    DataGenerator generator = new DataGenerator(eval, WekaClassifierErrors.this.m_ErrorScaler);
                    PlotData2D plotdata = generator.getPlotData();
                    plotdata.setPlotName(generator.getPlotInstances().relationName());
                    this.m_VisualizePanel.addPlot(plotdata);
                    this.m_VisualizePanel.setColourIndex(plotdata.getPlotInstances().classIndex());
                    if (this.m_VisualizePanel.getXIndex() == 0 && this.m_VisualizePanel.getYIndex() == 1) {
                        try {
                            this.m_VisualizePanel.setXIndex(this.m_VisualizePanel.getInstances().classIndex());
                            this.m_VisualizePanel.setYIndex(this.m_VisualizePanel.getInstances().classIndex() - 1);
                        }
                        catch (Exception e) {}
                    }
                }
                catch (Exception e) {
                    WekaClassifierErrors.this.getLogger().log(Level.SEVERE, "Failed to display token: " + token, e);
                }
            }

            public JComponent supplyComponent() {
                return this.m_VisualizePanel;
            }

            public void clearPanel() {
                this.m_VisualizePanel.removeAllPlots();
            }

            public void cleanUp() {
                this.m_VisualizePanel.removeAllPlots();
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return true;
    }

    public static class DataGenerator {
        protected Evaluation m_Evaluation;
        protected Instances m_PlotInstances;
        protected FastVector m_PlotShapes;
        protected FastVector m_PlotSizes;
        protected AbstractErrorScaler m_ErrorScaler;
        protected boolean m_Processed;

        public DataGenerator(Evaluation eval, AbstractErrorScaler scaler) {
            this.m_Evaluation = eval;
            this.m_ErrorScaler = scaler;
            this.m_Processed = false;
        }

        protected void process() {
            if (this.m_Processed) {
                return;
            }
            this.m_Processed = true;
            this.createDataset(this.m_Evaluation);
            try {
                Capabilities cap = this.m_ErrorScaler.getCapabilities();
                cap.testWithFail(this.m_PlotInstances.classAttribute(), true);
                ArrayList<Integer> scaled = this.m_ErrorScaler.scale((ArrayList)this.m_PlotSizes);
                this.m_PlotSizes = new FastVector();
                this.m_PlotSizes.addAll(scaled);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.m_PlotInstances = new Instances(this.m_PlotInstances, 0);
                this.m_PlotSizes = new FastVector();
                this.m_PlotShapes = new FastVector();
            }
        }

        public Evaluation getEvaluation() {
            return this.m_Evaluation;
        }

        public AbstractErrorScaler getErrorScaler() {
            return this.m_ErrorScaler;
        }

        public Instances getPlotInstances() {
            this.process();
            return this.m_PlotInstances;
        }

        protected void createDataset(Evaluation eval) {
            this.m_PlotShapes = new FastVector();
            this.m_PlotSizes = new FastVector();
            Attribute classAtt = eval.getHeader().classAttribute();
            ArrayList preds = eval.predictions();
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            atts.add(classAtt.copy("predicted" + classAtt.name()));
            atts.add((Attribute)classAtt.copy());
            this.m_PlotInstances = new Instances(eval.getHeader().relationName() + "-classifier_errors", atts, preds.size());
            this.m_PlotInstances.setClassIndex(this.m_PlotInstances.numAttributes() - 1);
            for (int i = 0; i < preds.size(); ++i) {
                Prediction pred = (Prediction)preds.get(i);
                double[] values = new double[]{pred.predicted(), pred.actual()};
                DenseInstance inst = new DenseInstance(pred.weight(), values);
                this.m_PlotInstances.add((Instance)inst);
                if (classAtt.isNominal()) {
                    if (weka.core.Utils.isMissingValue((double)pred.actual()) || weka.core.Utils.isMissingValue((double)pred.predicted())) {
                        this.m_PlotShapes.addElement((Object)new Integer(2000));
                    } else if (pred.predicted() != pred.actual()) {
                        this.m_PlotShapes.addElement((Object)new Integer(1000));
                    } else {
                        this.m_PlotShapes.addElement((Object)new Integer(-1));
                    }
                    this.m_PlotSizes.addElement((Object)new Integer(2));
                    continue;
                }
                Double errd = null;
                if (!weka.core.Utils.isMissingValue((double)pred.actual()) && !weka.core.Utils.isMissingValue((double)pred.predicted())) {
                    errd = new Double(pred.predicted() - pred.actual());
                    this.m_PlotShapes.addElement((Object)new Integer(-1));
                } else {
                    this.m_PlotShapes.addElement((Object)new Integer(2000));
                }
                this.m_PlotSizes.addElement(errd);
            }
        }

        public PlotData2D getPlotData() throws Exception {
            this.process();
            PlotData2D result = new PlotData2D(this.m_PlotInstances);
            result.setShapeSize((ArrayList)this.m_PlotSizes);
            result.setShapeType((ArrayList)this.m_PlotShapes);
            result.setPlotName("Classifier Errors (" + this.m_PlotInstances.relationName() + ")");
            result.addInstanceNumberAttribute();
            return result;
        }
    }
}

