/*
 * Decompiled with CFR 0.152.
 */
package weka.core.setupgenerator;

import java.io.Serializable;
import weka.core.Utils;
import weka.core.setupgenerator.AbstractParameter;
import weka.core.setupgenerator.ListParameter;
import weka.core.setupgenerator.MathParameter;

public class SpaceDimension
implements Serializable {
    private static final long serialVersionUID = -7709016830854739486L;
    protected int m_Type;
    protected double m_Min;
    protected double m_Max;
    protected double m_Step;
    protected String m_Label;
    protected int m_Width;
    protected String[] m_List;

    public SpaceDimension(AbstractParameter param) throws Exception {
        if (param instanceof MathParameter) {
            MathParameter math = (MathParameter)param;
            this.initFunction(math.getMin(), math.getMax(), math.getStep(), math.getProperty());
        } else if (param instanceof ListParameter) {
            ListParameter list = (ListParameter)param;
            this.initList(0, Utils.splitOptions((String)list.getList()).length - 1, Utils.splitOptions((String)list.getList()), list.getProperty());
        } else {
            throw new IllegalStateException("Parameter class '" + param.getClass().getName() + "' not handled!");
        }
    }

    public SpaceDimension(double min, double max, double step, String label) {
        this.initFunction(min, max, step, label);
    }

    public SpaceDimension(int min, int max, String[] list, String label) {
        this.initList(min, max, list, label);
    }

    protected void initFunction(double min, double max, double step, String label) {
        this.m_Type = 0;
        this.m_Min = min;
        this.m_Max = max;
        this.m_Step = step;
        this.m_Label = label;
        this.m_Width = (int)StrictMath.round((this.m_Max - this.m_Min) / this.m_Step) + 1;
        this.m_List = null;
        if (this.m_Min >= this.m_Max) {
            throw new IllegalArgumentException("Min must be smaller than Max!");
        }
        if (this.m_Step <= 0.0) {
            throw new IllegalArgumentException("Step must be a positive number!");
        }
        if (!Utils.eq((double)(this.m_Min + (double)(this.m_Width - 1) * this.m_Step), (double)this.m_Max)) {
            throw new IllegalArgumentException("Axis doesn't match! Provided max: " + this.m_Max + ", calculated max via min and step size: " + (this.m_Min + (double)(this.m_Width - 1) * this.m_Step));
        }
    }

    protected void initList(int min, int max, String[] list, String label) {
        this.m_Type = 1;
        this.m_Min = min;
        this.m_Max = max;
        this.m_Step = -1.0;
        this.m_Label = label;
        this.m_Width = max - min + 1;
        this.m_List = (String[])list.clone();
        if (this.m_Min >= (double)this.m_List.length) {
            throw new IllegalArgumentException("Min must be smaller than list length (min=" + min + ", list=" + list.length + ")!");
        }
        if (this.m_Max >= (double)this.m_List.length) {
            throw new IllegalArgumentException("Max must be smaller than list length (max=" + max + ", list=" + list.length + ")!");
        }
        if (this.m_Min >= this.m_Max) {
            throw new IllegalArgumentException("Min must be smaller than Max (min=" + min + ", max=" + max + ")!");
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SpaceDimension)) {
            return false;
        }
        SpaceDimension dim = (SpaceDimension)o;
        if (this.getType() != dim.getType()) {
            return false;
        }
        if (this.getType() == 0) {
            if (this.width() != dim.width()) {
                return false;
            }
            if (this.getMin() != dim.getMin()) {
                return false;
            }
            if (this.getStep() != dim.getStep()) {
                return false;
            }
            if (!this.getLabel().equals(dim.getLabel())) {
                return false;
            }
        } else if (this.getType() == 1) {
            if (this.getList().length != dim.getList().length) {
                return false;
            }
            for (int i = 0; i < this.getList().length; ++i) {
                if (this.getList()[i].equals(dim.getList()[i])) continue;
                return false;
            }
        } else {
            throw new IllegalStateException("Type '" + this.getType() + "' not handled!");
        }
        return true;
    }

    public int getType() {
        return this.m_Type;
    }

    public double getMin() {
        return this.m_Min;
    }

    public double getMax() {
        return this.m_Max;
    }

    public double getStep() {
        return this.m_Step;
    }

    public String getLabel() {
        return this.m_Label;
    }

    public int width() {
        return this.m_Width;
    }

    public String[] getList() {
        return this.m_List;
    }

    public Object getValue(int x) {
        if (x >= this.width()) {
            throw new IllegalArgumentException("Index out of scope on axis (" + x + " >= " + this.width() + ")!");
        }
        if (this.getType() == 0) {
            return new Double(this.m_Min + this.m_Step * (double)x);
        }
        if (this.getType() == 1) {
            return new String(this.m_List[(int)this.m_Min + x]);
        }
        throw new IllegalStateException("Type '" + this.getType() + "' not handled!");
    }

    public int getLocation(Object value) {
        int result = 0;
        if (this.getType() == 0) {
            double distance = this.m_Step;
            for (int i = 0; i < this.width(); ++i) {
                double currDistance = StrictMath.abs((Double)value - (Double)this.getValue(i));
                if (!Utils.sm((double)currDistance, (double)distance)) continue;
                distance = currDistance;
                result = i;
            }
        } else if (this.getType() == 1) {
            String valueStr = value.toString();
            for (int i = 0; i < this.width(); ++i) {
                if (!((String)this.getValue(i)).equals(valueStr)) continue;
                result = (int)this.m_Min + i;
                break;
            }
        } else {
            throw new IllegalStateException("Type '" + this.getType() + "' not handled!");
        }
        return result;
    }

    public boolean isOnBorder(double value) {
        return this.isOnBorder(this.getLocation(value));
    }

    public boolean isOnBorder(int location) {
        if (location == 0) {
            return true;
        }
        return location == this.width() - 1;
    }

    public SpaceDimension subdimension(int left, int right) {
        if (this.getType() == 0) {
            return new SpaceDimension((Double)this.getValue(left), (Double)this.getValue(right), this.getStep(), this.getLabel());
        }
        if (this.getType() == 1) {
            return new SpaceDimension(left, right, this.getList(), this.getLabel());
        }
        throw new IllegalStateException("Type '" + this.getType() + "' not handled!");
    }

    public String toString() {
        if (this.getType() == 0) {
            return "dimension: " + this.getLabel() + ", min: " + this.getMin() + ", max: " + this.getMax() + ", step: " + this.getStep();
        }
        if (this.getType() == 1) {
            return "dimension: " + this.getLabel() + ", min: " + this.getMin() + ", max: " + this.getMax() + ", list: " + Utils.arrayToString((Object)this.getList());
        }
        throw new IllegalStateException("Type '" + this.getType() + "' not handled!");
    }
}

