/*
 * Decompiled with CFR 0.152.
 */
package JSci.io;

import JSci.GlobalSettings;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.AbstractIntegerMatrix;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.AbstractIntegerVector;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public final class TextWriter
extends BufferedWriter {
    private final char delimiter;

    public TextWriter(Writer writer, char c) {
        super(writer);
        this.delimiter = c;
    }

    public TextWriter(String string, char c) throws IOException {
        this((Writer)new FileWriter(string), c);
    }

    public TextWriter(File file, char c) throws IOException {
        this((Writer)new FileWriter(file), c);
    }

    public void writeDouble(double d) throws IOException {
        this.write(Double.toString(d));
    }

    public void writeInt(int n) throws IOException {
        this.write(Integer.toString(n));
    }

    public void write(double[] dArray) throws IOException {
        int n;
        for (n = 0; n < dArray.length - 1; ++n) {
            this.writeDouble(dArray[n]);
            this.write(this.delimiter);
        }
        this.writeDouble(dArray[n]);
        this.newLine();
    }

    public void write(double[][] dArray) throws IOException {
        for (int i = 0; i < dArray.length; ++i) {
            this.write(dArray[i]);
        }
    }

    public void write(int[] nArray) throws IOException {
        int n;
        for (n = 0; n < nArray.length - 1; ++n) {
            this.writeInt(nArray[n]);
            this.write(this.delimiter);
        }
        this.writeInt(nArray[n]);
        this.newLine();
    }

    public void write(int[][] nArray) throws IOException {
        for (int i = 0; i < nArray.length; ++i) {
            this.write(nArray[i]);
        }
    }

    public void write(AbstractDoubleMatrix abstractDoubleMatrix) throws IOException {
        int n = abstractDoubleMatrix.rows();
        int n2 = abstractDoubleMatrix.columns();
        for (int i = 0; i < n; ++i) {
            int n3;
            for (n3 = 0; n3 < n2 - 1; ++n3) {
                this.writeDouble(abstractDoubleMatrix.getElement(i, n3));
                this.write(this.delimiter);
            }
            this.writeDouble(abstractDoubleMatrix.getElement(i, n3));
            this.newLine();
        }
    }

    public void writeTable(AbstractDoubleMatrix abstractDoubleMatrix) throws IOException {
        int n = abstractDoubleMatrix.rows();
        int n2 = abstractDoubleMatrix.columns();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = abstractDoubleMatrix.getElement(i, j);
                if (!(Math.abs(d) > GlobalSettings.ZERO_TOL)) continue;
                this.writeInt(i);
                this.write(this.delimiter);
                this.writeInt(j);
                this.write(this.delimiter);
                this.writeDouble(d);
                this.newLine();
            }
        }
    }

    public void write(AbstractIntegerMatrix abstractIntegerMatrix) throws IOException {
        int n = abstractIntegerMatrix.rows();
        int n2 = abstractIntegerMatrix.columns();
        for (int i = 0; i < n; ++i) {
            int n3;
            for (n3 = 0; n3 < n2 - 1; ++n3) {
                this.writeInt(abstractIntegerMatrix.getElement(i, n3));
                this.write(this.delimiter);
            }
            this.writeInt(abstractIntegerMatrix.getElement(i, n3));
            this.newLine();
        }
    }

    public void write(AbstractDoubleVector abstractDoubleVector) throws IOException {
        int n;
        int n2 = abstractDoubleVector.dimension();
        for (n = 0; n < n2 - 1; ++n) {
            this.writeDouble(abstractDoubleVector.getComponent(n));
            this.write(this.delimiter);
        }
        this.writeDouble(abstractDoubleVector.getComponent(n));
        this.newLine();
    }

    public void write(AbstractIntegerVector abstractIntegerVector) throws IOException {
        int n;
        int n2 = abstractIntegerVector.dimension();
        for (n = 0; n < n2 - 1; ++n) {
            this.writeInt(abstractIntegerVector.getComponent(n));
            this.write(this.delimiter);
        }
        this.writeInt(abstractIntegerVector.getComponent(n));
        this.newLine();
    }
}

